/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.RegulatoryComplianceControlsClient;
import com.azure.resourcemanager.security.fluent.models.RegulatoryComplianceControlInner;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceControlImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.RegulatoryComplianceControl;
import com.azure.resourcemanager.security.models.RegulatoryComplianceControls;

public final class RegulatoryComplianceControlsImpl
implements RegulatoryComplianceControls {
    private static final ClientLogger LOGGER = new ClientLogger(RegulatoryComplianceControlsImpl.class);
    private final RegulatoryComplianceControlsClient innerClient;
    private final SecurityManager serviceManager;

    public RegulatoryComplianceControlsImpl(RegulatoryComplianceControlsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<RegulatoryComplianceControl> list(String regulatoryComplianceStandardName) {
        PagedIterable<RegulatoryComplianceControlInner> inner = this.serviceClient().list(regulatoryComplianceStandardName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegulatoryComplianceControlImpl((RegulatoryComplianceControlInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RegulatoryComplianceControl> list(String regulatoryComplianceStandardName, String filter, Context context) {
        PagedIterable<RegulatoryComplianceControlInner> inner = this.serviceClient().list(regulatoryComplianceStandardName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegulatoryComplianceControlImpl((RegulatoryComplianceControlInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<RegulatoryComplianceControl> getWithResponse(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, Context context) {
        Response<RegulatoryComplianceControlInner> inner = this.serviceClient().getWithResponse(regulatoryComplianceStandardName, regulatoryComplianceControlName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RegulatoryComplianceControlImpl((RegulatoryComplianceControlInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RegulatoryComplianceControl get(String regulatoryComplianceStandardName, String regulatoryComplianceControlName) {
        RegulatoryComplianceControlInner inner = this.serviceClient().get(regulatoryComplianceStandardName, regulatoryComplianceControlName);
        if (inner != null) {
            return new RegulatoryComplianceControlImpl(inner, this.manager());
        }
        return null;
    }

    private RegulatoryComplianceControlsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

