/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.security.fluent.models.GetSensitivitySettingsResponseInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.UpdateSensitivitySettingsRequest;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final SecurityCenterImpl client;

    ResourceProvidersClientImpl(SecurityCenterImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GetSensitivitySettingsResponseInner>> updateSensitivitySettingsWithResponseAsync(UpdateSensitivitySettingsRequest sensitivitySettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sensitivitySettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sensitivitySettings is required and cannot be null."));
        }
        sensitivitySettings.validate();
        String apiVersion = "2023-02-15-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSensitivitySettings(this.client.getEndpoint(), "2023-02-15-preview", sensitivitySettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GetSensitivitySettingsResponseInner>> updateSensitivitySettingsWithResponseAsync(UpdateSensitivitySettingsRequest sensitivitySettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sensitivitySettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sensitivitySettings is required and cannot be null."));
        }
        sensitivitySettings.validate();
        String apiVersion = "2023-02-15-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSensitivitySettings(this.client.getEndpoint(), "2023-02-15-preview", sensitivitySettings, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GetSensitivitySettingsResponseInner> updateSensitivitySettingsAsync(UpdateSensitivitySettingsRequest sensitivitySettings) {
        return this.updateSensitivitySettingsWithResponseAsync(sensitivitySettings).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GetSensitivitySettingsResponseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GetSensitivitySettingsResponseInner> updateSensitivitySettingsWithResponse(UpdateSensitivitySettingsRequest sensitivitySettings, Context context) {
        return (Response)this.updateSensitivitySettingsWithResponseAsync(sensitivitySettings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetSensitivitySettingsResponseInner updateSensitivitySettings(UpdateSensitivitySettingsRequest sensitivitySettings) {
        return (GetSensitivitySettingsResponseInner)((Object)this.updateSensitivitySettingsWithResponse(sensitivitySettings, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GetSensitivitySettingsResponseInner>> getSensitivitySettingsWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2023-02-15-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSensitivitySettings(this.client.getEndpoint(), "2023-02-15-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GetSensitivitySettingsResponseInner>> getSensitivitySettingsWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2023-02-15-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSensitivitySettings(this.client.getEndpoint(), "2023-02-15-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GetSensitivitySettingsResponseInner> getSensitivitySettingsAsync() {
        return this.getSensitivitySettingsWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((Object)((GetSensitivitySettingsResponseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GetSensitivitySettingsResponseInner> getSensitivitySettingsWithResponse(Context context) {
        return (Response)this.getSensitivitySettingsWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetSensitivitySettingsResponseInner getSensitivitySettings() {
        return (GetSensitivitySettingsResponseInner)((Object)this.getSensitivitySettingsWithResponse(Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterResour")
    public static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Security/sensitivitySettings/current")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GetSensitivitySettingsResponseInner>> updateSensitivitySettings(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") UpdateSensitivitySettingsRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Security/sensitivitySettings/current")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GetSensitivitySettingsResponseInner>> getSensitivitySettings(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

