/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.RuleResultsInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.RuleResults;
import com.azure.resourcemanager.security.models.RuleResultsInput;
import com.azure.resourcemanager.security.models.RuleResultsProperties;
import java.util.List;

public final class RuleResultsImpl
implements RuleResults,
RuleResults.Definition,
RuleResults.Update {
    private RuleResultsInner innerObject;
    private final SecurityManager serviceManager;
    private String ruleId;
    private String resourceId;
    private String createWorkspaceId;
    private RuleResultsInput createBody;
    private String updateWorkspaceId;
    private RuleResultsInput updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public RuleResultsProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public RuleResultsInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public RuleResultsImpl withExistingResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public RuleResults create() {
        this.innerObject = (RuleResultsInner)((Object)this.serviceManager.serviceClient().getSqlVulnerabilityAssessmentBaselineRules().createOrUpdateWithResponse(this.ruleId, this.createWorkspaceId, this.resourceId, this.createBody, Context.NONE).getValue());
        return this;
    }

    @Override
    public RuleResults create(Context context) {
        this.innerObject = (RuleResultsInner)((Object)this.serviceManager.serviceClient().getSqlVulnerabilityAssessmentBaselineRules().createOrUpdateWithResponse(this.ruleId, this.createWorkspaceId, this.resourceId, this.createBody, context).getValue());
        return this;
    }

    RuleResultsImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new RuleResultsInner();
        this.serviceManager = serviceManager;
        this.ruleId = name;
        this.createWorkspaceId = null;
        this.createBody = new RuleResultsInput();
    }

    @Override
    public RuleResultsImpl update() {
        this.updateWorkspaceId = null;
        this.updateBody = new RuleResultsInput();
        return this;
    }

    @Override
    public RuleResults apply() {
        this.innerObject = (RuleResultsInner)((Object)this.serviceManager.serviceClient().getSqlVulnerabilityAssessmentBaselineRules().createOrUpdateWithResponse(this.ruleId, this.updateWorkspaceId, this.resourceId, this.updateBody, Context.NONE).getValue());
        return this;
    }

    @Override
    public RuleResults apply(Context context) {
        this.innerObject = (RuleResultsInner)((Object)this.serviceManager.serviceClient().getSqlVulnerabilityAssessmentBaselineRules().createOrUpdateWithResponse(this.ruleId, this.updateWorkspaceId, this.resourceId, this.updateBody, context).getValue());
        return this;
    }

    RuleResultsImpl(RuleResultsInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.ruleId = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}", "ruleId");
        this.resourceId = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}", "resourceId");
    }

    @Override
    public RuleResultsImpl withLatestScan(Boolean latestScan) {
        if (this.isInCreateMode()) {
            this.createBody.withLatestScan(latestScan);
            return this;
        }
        this.updateBody.withLatestScan(latestScan);
        return this;
    }

    @Override
    public RuleResultsImpl withResults(List<List<String>> results) {
        if (this.isInCreateMode()) {
            this.createBody.withResults(results);
            return this;
        }
        this.updateBody.withResults(results);
        return this;
    }

    @Override
    public RuleResultsImpl withWorkspaceId(String workspaceId) {
        if (this.isInCreateMode()) {
            this.createWorkspaceId = workspaceId;
            return this;
        }
        this.updateWorkspaceId = workspaceId;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

