/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecureScoreControlDefinitionsClient;
import com.azure.resourcemanager.security.fluent.models.SecureScoreControlDefinitionItemInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SecureScoreControlDefinitionItemImpl;
import com.azure.resourcemanager.security.models.SecureScoreControlDefinitionItem;
import com.azure.resourcemanager.security.models.SecureScoreControlDefinitions;

public final class SecureScoreControlDefinitionsImpl
implements SecureScoreControlDefinitions {
    private static final ClientLogger LOGGER = new ClientLogger(SecureScoreControlDefinitionsImpl.class);
    private final SecureScoreControlDefinitionsClient innerClient;
    private final SecurityManager serviceManager;

    public SecureScoreControlDefinitionsImpl(SecureScoreControlDefinitionsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SecureScoreControlDefinitionItem> list() {
        PagedIterable<SecureScoreControlDefinitionItemInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreControlDefinitionItemImpl((SecureScoreControlDefinitionItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecureScoreControlDefinitionItem> list(Context context) {
        PagedIterable<SecureScoreControlDefinitionItemInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreControlDefinitionItemImpl((SecureScoreControlDefinitionItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecureScoreControlDefinitionItem> listBySubscription() {
        PagedIterable<SecureScoreControlDefinitionItemInner> inner = this.serviceClient().listBySubscription();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreControlDefinitionItemImpl((SecureScoreControlDefinitionItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecureScoreControlDefinitionItem> listBySubscription(Context context) {
        PagedIterable<SecureScoreControlDefinitionItemInner> inner = this.serviceClient().listBySubscription(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreControlDefinitionItemImpl((SecureScoreControlDefinitionItemInner)((Object)inner1), this.manager()));
    }

    private SecureScoreControlDefinitionsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

