/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentMetadataResponseInner;
import com.azure.resourcemanager.security.models.AssessmentType;
import com.azure.resourcemanager.security.models.Categories;
import com.azure.resourcemanager.security.models.ImplementationEffort;
import com.azure.resourcemanager.security.models.SecurityAssessmentMetadataPartnerData;
import com.azure.resourcemanager.security.models.SecurityAssessmentMetadataPropertiesResponsePublishDates;
import com.azure.resourcemanager.security.models.SecurityAssessmentMetadataResponse;
import com.azure.resourcemanager.security.models.Severity;
import com.azure.resourcemanager.security.models.Tactics;
import com.azure.resourcemanager.security.models.Techniques;
import com.azure.resourcemanager.security.models.Threats;
import com.azure.resourcemanager.security.models.UserImpact;
import java.util.Collections;
import java.util.List;

public final class SecurityAssessmentMetadataResponseImpl
implements SecurityAssessmentMetadataResponse,
SecurityAssessmentMetadataResponse.Definition {
    private SecurityAssessmentMetadataResponseInner innerObject;
    private final SecurityManager serviceManager;
    private String assessmentMetadataName;

    SecurityAssessmentMetadataResponseImpl(SecurityAssessmentMetadataResponseInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SecurityAssessmentMetadataPropertiesResponsePublishDates publishDates() {
        return this.innerModel().publishDates();
    }

    @Override
    public String plannedDeprecationDate() {
        return this.innerModel().plannedDeprecationDate();
    }

    @Override
    public List<Tactics> tactics() {
        List<Tactics> inner = this.innerModel().tactics();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Techniques> techniques() {
        List<Techniques> inner = this.innerModel().techniques();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String policyDefinitionId() {
        return this.innerModel().policyDefinitionId();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String remediationDescription() {
        return this.innerModel().remediationDescription();
    }

    @Override
    public List<Categories> categories() {
        List<Categories> inner = this.innerModel().categories();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Severity severity() {
        return this.innerModel().severity();
    }

    @Override
    public UserImpact userImpact() {
        return this.innerModel().userImpact();
    }

    @Override
    public ImplementationEffort implementationEffort() {
        return this.innerModel().implementationEffort();
    }

    @Override
    public List<Threats> threats() {
        List<Threats> inner = this.innerModel().threats();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean preview() {
        return this.innerModel().preview();
    }

    @Override
    public AssessmentType assessmentType() {
        return this.innerModel().assessmentType();
    }

    @Override
    public SecurityAssessmentMetadataPartnerData partnerData() {
        return this.innerModel().partnerData();
    }

    @Override
    public SecurityAssessmentMetadataResponseInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityAssessmentMetadataResponse create() {
        this.innerObject = (SecurityAssessmentMetadataResponseInner)((Object)this.serviceManager.serviceClient().getAssessmentsMetadatas().createInSubscriptionWithResponse(this.assessmentMetadataName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponse create(Context context) {
        this.innerObject = (SecurityAssessmentMetadataResponseInner)((Object)this.serviceManager.serviceClient().getAssessmentsMetadatas().createInSubscriptionWithResponse(this.assessmentMetadataName, this.innerModel(), context).getValue());
        return this;
    }

    SecurityAssessmentMetadataResponseImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new SecurityAssessmentMetadataResponseInner();
        this.serviceManager = serviceManager;
        this.assessmentMetadataName = name;
    }

    @Override
    public SecurityAssessmentMetadataResponse refresh() {
        this.innerObject = (SecurityAssessmentMetadataResponseInner)((Object)this.serviceManager.serviceClient().getAssessmentsMetadatas().getInSubscriptionWithResponse(this.assessmentMetadataName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponse refresh(Context context) {
        this.innerObject = (SecurityAssessmentMetadataResponseInner)((Object)this.serviceManager.serviceClient().getAssessmentsMetadatas().getInSubscriptionWithResponse(this.assessmentMetadataName, context).getValue());
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withPublishDates(SecurityAssessmentMetadataPropertiesResponsePublishDates publishDates) {
        this.innerModel().withPublishDates(publishDates);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withPlannedDeprecationDate(String plannedDeprecationDate) {
        this.innerModel().withPlannedDeprecationDate(plannedDeprecationDate);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withTactics(List<Tactics> tactics) {
        this.innerModel().withTactics(tactics);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withTechniques(List<Techniques> techniques) {
        this.innerModel().withTechniques(techniques);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withRemediationDescription(String remediationDescription) {
        this.innerModel().withRemediationDescription(remediationDescription);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withCategories(List<Categories> categories) {
        this.innerModel().withCategories(categories);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withSeverity(Severity severity) {
        this.innerModel().withSeverity(severity);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withUserImpact(UserImpact userImpact) {
        this.innerModel().withUserImpact(userImpact);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withImplementationEffort(ImplementationEffort implementationEffort) {
        this.innerModel().withImplementationEffort(implementationEffort);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withThreats(List<Threats> threats) {
        this.innerModel().withThreats(threats);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withPreview(Boolean preview) {
        this.innerModel().withPreview(preview);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withAssessmentType(AssessmentType assessmentType) {
        this.innerModel().withAssessmentType(assessmentType);
        return this;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl withPartnerData(SecurityAssessmentMetadataPartnerData partnerData) {
        this.innerModel().withPartnerData(partnerData);
        return this;
    }
}

