/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecurityConnectorApplicationOperationsClient;
import com.azure.resourcemanager.security.fluent.models.ApplicationInner;
import com.azure.resourcemanager.security.implementation.ApplicationImpl;
import com.azure.resourcemanager.security.models.Application;
import com.azure.resourcemanager.security.models.SecurityConnectorApplicationOperations;

public final class SecurityConnectorApplicationOperationsImpl
implements SecurityConnectorApplicationOperations {
    private static final ClientLogger LOGGER = new ClientLogger(SecurityConnectorApplicationOperationsImpl.class);
    private final SecurityConnectorApplicationOperationsClient innerClient;
    private final SecurityManager serviceManager;

    public SecurityConnectorApplicationOperationsImpl(SecurityConnectorApplicationOperationsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Application> getWithResponse(String resourceGroupName, String securityConnectorName, String applicationId, Context context) {
        Response<ApplicationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, applicationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationImpl((ApplicationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Application get(String resourceGroupName, String securityConnectorName, String applicationId) {
        ApplicationInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, applicationId);
        if (inner != null) {
            return new ApplicationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Application> createOrUpdateWithResponse(String resourceGroupName, String securityConnectorName, String applicationId, ApplicationInner application, Context context) {
        Response<ApplicationInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, securityConnectorName, applicationId, application, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationImpl((ApplicationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Application createOrUpdate(String resourceGroupName, String securityConnectorName, String applicationId, ApplicationInner application) {
        ApplicationInner inner = this.serviceClient().createOrUpdate(resourceGroupName, securityConnectorName, applicationId, application);
        if (inner != null) {
            return new ApplicationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String securityConnectorName, String applicationId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, securityConnectorName, applicationId, context);
    }

    @Override
    public void delete(String resourceGroupName, String securityConnectorName, String applicationId) {
        this.serviceClient().delete(resourceGroupName, securityConnectorName, applicationId);
    }

    private SecurityConnectorApplicationOperationsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

