/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecurityConnectorApplicationsClient;
import com.azure.resourcemanager.security.fluent.models.ApplicationInner;
import com.azure.resourcemanager.security.implementation.ApplicationImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.Application;
import com.azure.resourcemanager.security.models.SecurityConnectorApplications;

public final class SecurityConnectorApplicationsImpl
implements SecurityConnectorApplications {
    private static final ClientLogger LOGGER = new ClientLogger(SecurityConnectorApplicationsImpl.class);
    private final SecurityConnectorApplicationsClient innerClient;
    private final SecurityManager serviceManager;

    public SecurityConnectorApplicationsImpl(SecurityConnectorApplicationsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Application> list(String resourceGroupName, String securityConnectorName) {
        PagedIterable<ApplicationInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApplicationImpl((ApplicationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Application> list(String resourceGroupName, String securityConnectorName, Context context) {
        PagedIterable<ApplicationInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApplicationImpl((ApplicationInner)((Object)inner1), this.manager()));
    }

    private SecurityConnectorApplicationsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

