/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecurityConnectorsClient;
import com.azure.resourcemanager.security.fluent.models.SecurityConnectorInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SecurityConnectorImpl;
import com.azure.resourcemanager.security.models.SecurityConnector;
import com.azure.resourcemanager.security.models.SecurityConnectors;

public final class SecurityConnectorsImpl
implements SecurityConnectors {
    private static final ClientLogger LOGGER = new ClientLogger(SecurityConnectorsImpl.class);
    private final SecurityConnectorsClient innerClient;
    private final SecurityManager serviceManager;

    public SecurityConnectorsImpl(SecurityConnectorsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SecurityConnector> list() {
        PagedIterable<SecurityConnectorInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityConnectorImpl((SecurityConnectorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecurityConnector> list(Context context) {
        PagedIterable<SecurityConnectorInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityConnectorImpl((SecurityConnectorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecurityConnector> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SecurityConnectorInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityConnectorImpl((SecurityConnectorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecurityConnector> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SecurityConnectorInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityConnectorImpl((SecurityConnectorInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SecurityConnector> getByResourceGroupWithResponse(String resourceGroupName, String securityConnectorName, Context context) {
        Response<SecurityConnectorInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, securityConnectorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityConnectorImpl((SecurityConnectorInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityConnector getByResourceGroup(String resourceGroupName, String securityConnectorName) {
        SecurityConnectorInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, securityConnectorName);
        if (inner != null) {
            return new SecurityConnectorImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String securityConnectorName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, securityConnectorName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String securityConnectorName) {
        this.serviceClient().delete(resourceGroupName, securityConnectorName);
    }

    @Override
    public SecurityConnector getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        return (SecurityConnector)this.getByResourceGroupWithResponse(resourceGroupName, securityConnectorName, Context.NONE).getValue();
    }

    @Override
    public Response<SecurityConnector> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, securityConnectorName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, securityConnectorName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, securityConnectorName, context);
    }

    private SecurityConnectorsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityConnectorImpl define(String name) {
        return new SecurityConnectorImpl(name, this.manager());
    }
}

