/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.SecurityContactInner;
import com.azure.resourcemanager.security.models.NotificationsSource;
import com.azure.resourcemanager.security.models.SecurityContact;
import com.azure.resourcemanager.security.models.SecurityContactName;
import com.azure.resourcemanager.security.models.SecurityContactPropertiesNotificationsByRole;
import java.util.Collections;
import java.util.List;

public final class SecurityContactImpl
implements SecurityContact,
SecurityContact.Definition {
    private SecurityContactInner innerObject;
    private final SecurityManager serviceManager;
    private SecurityContactName securityContactName;

    SecurityContactImpl(SecurityContactInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String emails() {
        return this.innerModel().emails();
    }

    @Override
    public String phone() {
        return this.innerModel().phone();
    }

    @Override
    public Boolean isEnabled() {
        return this.innerModel().isEnabled();
    }

    @Override
    public List<NotificationsSource> notificationsSources() {
        List<NotificationsSource> inner = this.innerModel().notificationsSources();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public SecurityContactPropertiesNotificationsByRole notificationsByRole() {
        return this.innerModel().notificationsByRole();
    }

    @Override
    public SecurityContactInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityContact create() {
        this.innerObject = (SecurityContactInner)((Object)this.serviceManager.serviceClient().getSecurityContacts().createWithResponse(this.securityContactName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityContact create(Context context) {
        this.innerObject = (SecurityContactInner)((Object)this.serviceManager.serviceClient().getSecurityContacts().createWithResponse(this.securityContactName, this.innerModel(), context).getValue());
        return this;
    }

    SecurityContactImpl(SecurityContactName name, SecurityManager serviceManager) {
        this.innerObject = new SecurityContactInner();
        this.serviceManager = serviceManager;
        this.securityContactName = name;
    }

    @Override
    public SecurityContact refresh() {
        this.innerObject = (SecurityContactInner)((Object)this.serviceManager.serviceClient().getSecurityContacts().getWithResponse(this.securityContactName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityContact refresh(Context context) {
        this.innerObject = (SecurityContactInner)((Object)this.serviceManager.serviceClient().getSecurityContacts().getWithResponse(this.securityContactName, context).getValue());
        return this;
    }

    @Override
    public SecurityContactImpl withEmails(String emails) {
        this.innerModel().withEmails(emails);
        return this;
    }

    @Override
    public SecurityContactImpl withPhone(String phone) {
        this.innerModel().withPhone(phone);
        return this;
    }

    @Override
    public SecurityContactImpl withIsEnabled(Boolean isEnabled) {
        this.innerModel().withIsEnabled(isEnabled);
        return this;
    }

    @Override
    public SecurityContactImpl withNotificationsSources(List<NotificationsSource> notificationsSources) {
        this.innerModel().withNotificationsSources(notificationsSources);
        return this;
    }

    @Override
    public SecurityContactImpl withNotificationsByRole(SecurityContactPropertiesNotificationsByRole notificationsByRole) {
        this.innerModel().withNotificationsByRole(notificationsByRole);
        return this;
    }
}

