/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecuritySolutionsClient;
import com.azure.resourcemanager.security.fluent.models.SecuritySolutionInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SecuritySolutionImpl;
import com.azure.resourcemanager.security.models.SecuritySolution;
import com.azure.resourcemanager.security.models.SecuritySolutions;

public final class SecuritySolutionsImpl
implements SecuritySolutions {
    private static final ClientLogger LOGGER = new ClientLogger(SecuritySolutionsImpl.class);
    private final SecuritySolutionsClient innerClient;
    private final SecurityManager serviceManager;

    public SecuritySolutionsImpl(SecuritySolutionsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SecuritySolution> list() {
        PagedIterable<SecuritySolutionInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecuritySolutionImpl((SecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecuritySolution> list(Context context) {
        PagedIterable<SecuritySolutionInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecuritySolutionImpl((SecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SecuritySolution> getWithResponse(String resourceGroupName, String ascLocation, String securitySolutionName, Context context) {
        Response<SecuritySolutionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, ascLocation, securitySolutionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecuritySolutionImpl((SecuritySolutionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecuritySolution get(String resourceGroupName, String ascLocation, String securitySolutionName) {
        SecuritySolutionInner inner = this.serviceClient().get(resourceGroupName, ascLocation, securitySolutionName);
        if (inner != null) {
            return new SecuritySolutionImpl(inner, this.manager());
        }
        return null;
    }

    private SecuritySolutionsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

