/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecuritySolutionsReferenceDatasClient;
import com.azure.resourcemanager.security.fluent.models.SecuritySolutionsReferenceDataListInner;
import com.azure.resourcemanager.security.implementation.SecuritySolutionsReferenceDataListImpl;
import com.azure.resourcemanager.security.models.SecuritySolutionsReferenceDataList;
import com.azure.resourcemanager.security.models.SecuritySolutionsReferenceDatas;

public final class SecuritySolutionsReferenceDatasImpl
implements SecuritySolutionsReferenceDatas {
    private static final ClientLogger LOGGER = new ClientLogger(SecuritySolutionsReferenceDatasImpl.class);
    private final SecuritySolutionsReferenceDatasClient innerClient;
    private final SecurityManager serviceManager;

    public SecuritySolutionsReferenceDatasImpl(SecuritySolutionsReferenceDatasClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SecuritySolutionsReferenceDataList> listWithResponse(Context context) {
        Response<SecuritySolutionsReferenceDataListInner> inner = this.serviceClient().listWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecuritySolutionsReferenceDataListImpl((SecuritySolutionsReferenceDataListInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SecuritySolutionsReferenceDataList list() {
        SecuritySolutionsReferenceDataListInner inner = this.serviceClient().list();
        if (inner != null) {
            return new SecuritySolutionsReferenceDataListImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SecuritySolutionsReferenceDataList> listByHomeRegionWithResponse(String ascLocation, Context context) {
        Response<SecuritySolutionsReferenceDataListInner> inner = this.serviceClient().listByHomeRegionWithResponse(ascLocation, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecuritySolutionsReferenceDataListImpl((SecuritySolutionsReferenceDataListInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SecuritySolutionsReferenceDataList listByHomeRegion(String ascLocation) {
        SecuritySolutionsReferenceDataListInner inner = this.serviceClient().listByHomeRegion(ascLocation);
        if (inner != null) {
            return new SecuritySolutionsReferenceDataListImpl(inner, this.manager());
        }
        return null;
    }

    private SecuritySolutionsReferenceDatasClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

