/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.ServerVulnerabilityAssessmentsSettingsClient;
import com.azure.resourcemanager.security.fluent.models.ServerVulnerabilityAssessmentsSettingInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.ServerVulnerabilityAssessmentsSettingImpl;
import com.azure.resourcemanager.security.models.ServerVulnerabilityAssessmentsSetting;
import com.azure.resourcemanager.security.models.ServerVulnerabilityAssessmentsSettingKindName;
import com.azure.resourcemanager.security.models.ServerVulnerabilityAssessmentsSettings;

public final class ServerVulnerabilityAssessmentsSettingsImpl
implements ServerVulnerabilityAssessmentsSettings {
    private static final ClientLogger LOGGER = new ClientLogger(ServerVulnerabilityAssessmentsSettingsImpl.class);
    private final ServerVulnerabilityAssessmentsSettingsClient innerClient;
    private final SecurityManager serviceManager;

    public ServerVulnerabilityAssessmentsSettingsImpl(ServerVulnerabilityAssessmentsSettingsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ServerVulnerabilityAssessmentsSetting> list() {
        PagedIterable<ServerVulnerabilityAssessmentsSettingInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerVulnerabilityAssessmentsSettingImpl((ServerVulnerabilityAssessmentsSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ServerVulnerabilityAssessmentsSetting> list(Context context) {
        PagedIterable<ServerVulnerabilityAssessmentsSettingInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerVulnerabilityAssessmentsSettingImpl((ServerVulnerabilityAssessmentsSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ServerVulnerabilityAssessmentsSetting> getWithResponse(ServerVulnerabilityAssessmentsSettingKindName settingKind, Context context) {
        Response<ServerVulnerabilityAssessmentsSettingInner> inner = this.serviceClient().getWithResponse(settingKind, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServerVulnerabilityAssessmentsSettingImpl((ServerVulnerabilityAssessmentsSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ServerVulnerabilityAssessmentsSetting get(ServerVulnerabilityAssessmentsSettingKindName settingKind) {
        ServerVulnerabilityAssessmentsSettingInner inner = this.serviceClient().get(settingKind);
        if (inner != null) {
            return new ServerVulnerabilityAssessmentsSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ServerVulnerabilityAssessmentsSetting> createOrUpdateWithResponse(ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingInner serverVulnerabilityAssessmentsSetting, Context context) {
        Response<ServerVulnerabilityAssessmentsSettingInner> inner = this.serviceClient().createOrUpdateWithResponse(settingKind, serverVulnerabilityAssessmentsSetting, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServerVulnerabilityAssessmentsSettingImpl((ServerVulnerabilityAssessmentsSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ServerVulnerabilityAssessmentsSetting createOrUpdate(ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingInner serverVulnerabilityAssessmentsSetting) {
        ServerVulnerabilityAssessmentsSettingInner inner = this.serviceClient().createOrUpdate(settingKind, serverVulnerabilityAssessmentsSetting);
        if (inner != null) {
            return new ServerVulnerabilityAssessmentsSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(ServerVulnerabilityAssessmentsSettingKindName settingKind, Context context) {
        return this.serviceClient().deleteWithResponse(settingKind, context);
    }

    @Override
    public void delete(ServerVulnerabilityAssessmentsSettingKindName settingKind) {
        this.serviceClient().delete(settingKind);
    }

    private ServerVulnerabilityAssessmentsSettingsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

