/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SettingsClient;
import com.azure.resourcemanager.security.fluent.models.SettingInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SettingImpl;
import com.azure.resourcemanager.security.models.Setting;
import com.azure.resourcemanager.security.models.SettingNameAutoGenerated;
import com.azure.resourcemanager.security.models.Settings;

public final class SettingsImpl
implements Settings {
    private static final ClientLogger LOGGER = new ClientLogger(SettingsImpl.class);
    private final SettingsClient innerClient;
    private final SecurityManager serviceManager;

    public SettingsImpl(SettingsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Setting> list() {
        PagedIterable<SettingInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SettingImpl((SettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Setting> list(Context context) {
        PagedIterable<SettingInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SettingImpl((SettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Setting> getWithResponse(SettingNameAutoGenerated settingName, Context context) {
        Response<SettingInner> inner = this.serviceClient().getWithResponse(settingName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SettingImpl((SettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Setting get(SettingNameAutoGenerated settingName) {
        SettingInner inner = this.serviceClient().get(settingName);
        if (inner != null) {
            return new SettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Setting> updateWithResponse(SettingNameAutoGenerated settingName, SettingInner setting, Context context) {
        Response<SettingInner> inner = this.serviceClient().updateWithResponse(settingName, setting, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SettingImpl((SettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Setting update(SettingNameAutoGenerated settingName, SettingInner setting) {
        SettingInner inner = this.serviceClient().update(settingName, setting);
        if (inner != null) {
            return new SettingImpl(inner, this.manager());
        }
        return null;
    }

    private SettingsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

