/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentBaselineRulesClient;
import com.azure.resourcemanager.security.fluent.models.RuleResultsInner;
import com.azure.resourcemanager.security.fluent.models.RulesResultsInner;
import com.azure.resourcemanager.security.implementation.RuleResultsImpl;
import com.azure.resourcemanager.security.implementation.RulesResultsImpl;
import com.azure.resourcemanager.security.models.RuleResults;
import com.azure.resourcemanager.security.models.RulesResults;
import com.azure.resourcemanager.security.models.RulesResultsInput;
import com.azure.resourcemanager.security.models.SqlVulnerabilityAssessmentBaselineRules;

public final class SqlVulnerabilityAssessmentBaselineRulesImpl
implements SqlVulnerabilityAssessmentBaselineRules {
    private static final ClientLogger LOGGER = new ClientLogger(SqlVulnerabilityAssessmentBaselineRulesImpl.class);
    private final SqlVulnerabilityAssessmentBaselineRulesClient innerClient;
    private final SecurityManager serviceManager;

    public SqlVulnerabilityAssessmentBaselineRulesImpl(SqlVulnerabilityAssessmentBaselineRulesClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<RuleResults> getWithResponse(String ruleId, String workspaceId, String resourceId, Context context) {
        Response<RuleResultsInner> inner = this.serviceClient().getWithResponse(ruleId, workspaceId, resourceId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RuleResultsImpl((RuleResultsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RuleResults get(String ruleId, String workspaceId, String resourceId) {
        RuleResultsInner inner = this.serviceClient().get(ruleId, workspaceId, resourceId);
        if (inner != null) {
            return new RuleResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String ruleId, String workspaceId, String resourceId, Context context) {
        return this.serviceClient().deleteWithResponse(ruleId, workspaceId, resourceId, context);
    }

    @Override
    public void delete(String ruleId, String workspaceId, String resourceId) {
        this.serviceClient().delete(ruleId, workspaceId, resourceId);
    }

    @Override
    public Response<RulesResults> listWithResponse(String workspaceId, String resourceId, Context context) {
        Response<RulesResultsInner> inner = this.serviceClient().listWithResponse(workspaceId, resourceId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RulesResultsImpl((RulesResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RulesResults list(String workspaceId, String resourceId) {
        RulesResultsInner inner = this.serviceClient().list(workspaceId, resourceId);
        if (inner != null) {
            return new RulesResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RulesResults> addWithResponse(String workspaceId, String resourceId, RulesResultsInput body, Context context) {
        Response<RulesResultsInner> inner = this.serviceClient().addWithResponse(workspaceId, resourceId, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RulesResultsImpl((RulesResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RulesResults add(String workspaceId, String resourceId) {
        RulesResultsInner inner = this.serviceClient().add(workspaceId, resourceId);
        if (inner != null) {
            return new RulesResultsImpl(inner, this.manager());
        }
        return null;
    }

    private SqlVulnerabilityAssessmentBaselineRulesClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public RuleResultsImpl define(String name) {
        return new RuleResultsImpl(name, this.manager());
    }
}

