/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentScanResultsClient;
import com.azure.resourcemanager.security.fluent.models.ScanResultInner;
import com.azure.resourcemanager.security.fluent.models.ScanResultsInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class SqlVulnerabilityAssessmentScanResultsClientImpl
implements SqlVulnerabilityAssessmentScanResultsClient {
    private final SqlVulnerabilityAssessmentScanResultsService service;
    private final SecurityCenterImpl client;

    SqlVulnerabilityAssessmentScanResultsClientImpl(SecurityCenterImpl client) {
        this.service = (SqlVulnerabilityAssessmentScanResultsService)RestProxy.create(SqlVulnerabilityAssessmentScanResultsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScanResultInner>> getWithResponseAsync(String scanId, String scanResultId, String workspaceId, String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (scanResultId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanResultId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scanId, scanResultId, workspaceId, "2023-02-01-preview", resourceId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScanResultInner>> getWithResponseAsync(String scanId, String scanResultId, String workspaceId, String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (scanResultId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanResultId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scanId, scanResultId, workspaceId, "2023-02-01-preview", resourceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScanResultInner> getAsync(String scanId, String scanResultId, String workspaceId, String resourceId) {
        return this.getWithResponseAsync(scanId, scanResultId, workspaceId, resourceId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ScanResultInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ScanResultInner> getWithResponse(String scanId, String scanResultId, String workspaceId, String resourceId, Context context) {
        return (Response)this.getWithResponseAsync(scanId, scanResultId, workspaceId, resourceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScanResultInner get(String scanId, String scanResultId, String workspaceId, String resourceId) {
        return (ScanResultInner)((Object)this.getWithResponse(scanId, scanResultId, workspaceId, resourceId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScanResultsInner>> listWithResponseAsync(String scanId, String workspaceId, String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), scanId, workspaceId, "2023-02-01-preview", resourceId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScanResultsInner>> listWithResponseAsync(String scanId, String workspaceId, String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), scanId, workspaceId, "2023-02-01-preview", resourceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScanResultsInner> listAsync(String scanId, String workspaceId, String resourceId) {
        return this.listWithResponseAsync(scanId, workspaceId, resourceId).flatMap(res -> Mono.justOrEmpty((Object)((ScanResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ScanResultsInner> listWithResponse(String scanId, String workspaceId, String resourceId, Context context) {
        return (Response)this.listWithResponseAsync(scanId, workspaceId, resourceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScanResultsInner list(String scanId, String workspaceId, String resourceId) {
        return (ScanResultsInner)this.listWithResponse(scanId, workspaceId, resourceId, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterSqlVul")
    public static interface SqlVulnerabilityAssessmentScanResultsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults/{scanResultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScanResultInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scanId") String var2, @PathParam(value="scanResultId") String var3, @QueryParam(value="workspaceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="resourceId", encoded=true) String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScanResultsInner>> list(@HostParam(value="$host") String var1, @PathParam(value="scanId") String var2, @QueryParam(value="workspaceId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="resourceId", encoded=true) String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

