/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentScansClient;
import com.azure.resourcemanager.security.fluent.models.ScanInner;
import com.azure.resourcemanager.security.fluent.models.ScansInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class SqlVulnerabilityAssessmentScansClientImpl
implements SqlVulnerabilityAssessmentScansClient {
    private final SqlVulnerabilityAssessmentScansService service;
    private final SecurityCenterImpl client;

    SqlVulnerabilityAssessmentScansClientImpl(SecurityCenterImpl client) {
        this.service = (SqlVulnerabilityAssessmentScansService)RestProxy.create(SqlVulnerabilityAssessmentScansService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScanInner>> getWithResponseAsync(String scanId, String workspaceId, String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scanId, workspaceId, "2023-02-01-preview", resourceId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScanInner>> getWithResponseAsync(String scanId, String workspaceId, String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scanId, workspaceId, "2023-02-01-preview", resourceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScanInner> getAsync(String scanId, String workspaceId, String resourceId) {
        return this.getWithResponseAsync(scanId, workspaceId, resourceId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ScanInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ScanInner> getWithResponse(String scanId, String workspaceId, String resourceId, Context context) {
        return (Response)this.getWithResponseAsync(scanId, workspaceId, resourceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScanInner get(String scanId, String workspaceId, String resourceId) {
        return (ScanInner)((Object)this.getWithResponse(scanId, workspaceId, resourceId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScansInner>> listWithResponseAsync(String workspaceId, String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), workspaceId, "2023-02-01-preview", resourceId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScansInner>> listWithResponseAsync(String workspaceId, String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), workspaceId, "2023-02-01-preview", resourceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScansInner> listAsync(String workspaceId, String resourceId) {
        return this.listWithResponseAsync(workspaceId, resourceId).flatMap(res -> Mono.justOrEmpty((Object)((ScansInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ScansInner> listWithResponse(String workspaceId, String resourceId, Context context) {
        return (Response)this.listWithResponseAsync(workspaceId, resourceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScansInner list(String workspaceId, String resourceId) {
        return (ScansInner)this.listWithResponse(workspaceId, resourceId, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterSqlVul")
    public static interface SqlVulnerabilityAssessmentScansService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScanInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scanId") String var2, @QueryParam(value="workspaceId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="resourceId", encoded=true) String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScansInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="workspaceId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceId", encoded=true) String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

