/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.WorkspaceSettingInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.WorkspaceSetting;

public final class WorkspaceSettingImpl
implements WorkspaceSetting,
WorkspaceSetting.Definition,
WorkspaceSetting.Update {
    private WorkspaceSettingInner innerObject;
    private final SecurityManager serviceManager;
    private String workspaceSettingName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String workspaceId() {
        return this.innerModel().workspaceId();
    }

    @Override
    public String scope() {
        return this.innerModel().scope();
    }

    @Override
    public WorkspaceSettingInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkspaceSetting create() {
        this.innerObject = (WorkspaceSettingInner)((Object)this.serviceManager.serviceClient().getWorkspaceSettings().createWithResponse(this.workspaceSettingName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public WorkspaceSetting create(Context context) {
        this.innerObject = (WorkspaceSettingInner)((Object)this.serviceManager.serviceClient().getWorkspaceSettings().createWithResponse(this.workspaceSettingName, this.innerModel(), context).getValue());
        return this;
    }

    WorkspaceSettingImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new WorkspaceSettingInner();
        this.serviceManager = serviceManager;
        this.workspaceSettingName = name;
    }

    @Override
    public WorkspaceSettingImpl update() {
        return this;
    }

    @Override
    public WorkspaceSetting apply() {
        this.innerObject = (WorkspaceSettingInner)((Object)this.serviceManager.serviceClient().getWorkspaceSettings().updateWithResponse(this.workspaceSettingName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public WorkspaceSetting apply(Context context) {
        this.innerObject = (WorkspaceSettingInner)((Object)this.serviceManager.serviceClient().getWorkspaceSettings().updateWithResponse(this.workspaceSettingName, this.innerModel(), context).getValue());
        return this;
    }

    WorkspaceSettingImpl(WorkspaceSettingInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.workspaceSettingName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaceSettings");
    }

    @Override
    public WorkspaceSetting refresh() {
        this.innerObject = (WorkspaceSettingInner)((Object)this.serviceManager.serviceClient().getWorkspaceSettings().getWithResponse(this.workspaceSettingName, Context.NONE).getValue());
        return this;
    }

    @Override
    public WorkspaceSetting refresh(Context context) {
        this.innerObject = (WorkspaceSettingInner)((Object)this.serviceManager.serviceClient().getWorkspaceSettings().getWithResponse(this.workspaceSettingName, context).getValue());
        return this;
    }

    @Override
    public WorkspaceSettingImpl withWorkspaceId(String workspaceId) {
        this.innerModel().withWorkspaceId(workspaceId);
        return this;
    }

    @Override
    public WorkspaceSettingImpl withScope(String scope) {
        this.innerModel().withScope(scope);
        return this;
    }
}

