/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.WorkspaceSettingsClient;
import com.azure.resourcemanager.security.fluent.models.WorkspaceSettingInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.WorkspaceSettingImpl;
import com.azure.resourcemanager.security.models.WorkspaceSetting;
import com.azure.resourcemanager.security.models.WorkspaceSettings;

public final class WorkspaceSettingsImpl
implements WorkspaceSettings {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceSettingsImpl.class);
    private final WorkspaceSettingsClient innerClient;
    private final SecurityManager serviceManager;

    public WorkspaceSettingsImpl(WorkspaceSettingsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<WorkspaceSetting> list() {
        PagedIterable<WorkspaceSettingInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceSettingImpl((WorkspaceSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WorkspaceSetting> list(Context context) {
        PagedIterable<WorkspaceSettingInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceSettingImpl((WorkspaceSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<WorkspaceSetting> getWithResponse(String workspaceSettingName, Context context) {
        Response<WorkspaceSettingInner> inner = this.serviceClient().getWithResponse(workspaceSettingName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkspaceSettingImpl((WorkspaceSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public WorkspaceSetting get(String workspaceSettingName) {
        WorkspaceSettingInner inner = this.serviceClient().get(workspaceSettingName);
        if (inner != null) {
            return new WorkspaceSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String workspaceSettingName, Context context) {
        return this.serviceClient().deleteWithResponse(workspaceSettingName, context);
    }

    @Override
    public void delete(String workspaceSettingName) {
        this.serviceClient().delete(workspaceSettingName);
    }

    @Override
    public WorkspaceSetting getById(String id) {
        String workspaceSettingName = ResourceManagerUtils.getValueFromIdByName(id, "workspaceSettings");
        if (workspaceSettingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaceSettings'.", id)));
        }
        return (WorkspaceSetting)this.getWithResponse(workspaceSettingName, Context.NONE).getValue();
    }

    @Override
    public Response<WorkspaceSetting> getByIdWithResponse(String id, Context context) {
        String workspaceSettingName = ResourceManagerUtils.getValueFromIdByName(id, "workspaceSettings");
        if (workspaceSettingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaceSettings'.", id)));
        }
        return this.getWithResponse(workspaceSettingName, context);
    }

    @Override
    public void deleteById(String id) {
        String workspaceSettingName = ResourceManagerUtils.getValueFromIdByName(id, "workspaceSettings");
        if (workspaceSettingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaceSettings'.", id)));
        }
        this.deleteWithResponse(workspaceSettingName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String workspaceSettingName = ResourceManagerUtils.getValueFromIdByName(id, "workspaceSettings");
        if (workspaceSettingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaceSettings'.", id)));
        }
        return this.deleteWithResponse(workspaceSettingName, context);
    }

    private WorkspaceSettingsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkspaceSettingImpl define(String name) {
        return new WorkspaceSettingImpl(name, this.manager());
    }
}

