/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.ApplicationInner;
import com.azure.resourcemanager.security.models.ApplicationSourceResourceType;
import java.util.List;

public interface Application {
    public String id();

    public String name();

    public String type();

    public String displayName();

    public String description();

    public ApplicationSourceResourceType sourceResourceType();

    public List<Object> conditionSets();

    public ApplicationInner innerModel();

    public Update update();

    public Application refresh();

    public Application refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithConditionSets {
            public Update withConditionSets(List<Object> var1);
        }

        public static interface WithSourceResourceType {
            public Update withSourceResourceType(ApplicationSourceResourceType var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDisplayName,
    UpdateStages.WithDescription,
    UpdateStages.WithSourceResourceType,
    UpdateStages.WithConditionSets {
        public Application apply();

        public Application apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithConditionSets {
            public WithCreate withConditionSets(List<Object> var1);
        }

        public static interface WithSourceResourceType {
            public WithCreate withSourceResourceType(ApplicationSourceResourceType var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithCreate
        extends WithDisplayName,
        WithDescription,
        WithSourceResourceType,
        WithConditionSets {
            public Application create();

            public Application create(Context var1);
        }

        public static interface Blank
        extends WithCreate {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

