/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.AutomationInner;
import com.azure.resourcemanager.security.models.AutomationAction;
import com.azure.resourcemanager.security.models.AutomationScope;
import com.azure.resourcemanager.security.models.AutomationSource;
import com.azure.resourcemanager.security.models.AutomationValidationStatus;
import java.util.List;
import java.util.Map;

public interface Automation {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String description();

    public Boolean isEnabled();

    public List<AutomationScope> scopes();

    public List<AutomationSource> sources();

    public List<AutomationAction> actions();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public AutomationInner innerModel();

    public Update update();

    public Automation refresh();

    public Automation refresh(Context var1);

    public Response<AutomationValidationStatus> validateWithResponse(AutomationInner var1, Context var2);

    public AutomationValidationStatus validate(AutomationInner var1);

    public static interface UpdateStages {

        public static interface WithActions {
            public Update withActions(List<AutomationAction> var1);
        }

        public static interface WithSources {
            public Update withSources(List<AutomationSource> var1);
        }

        public static interface WithScopes {
            public Update withScopes(List<AutomationScope> var1);
        }

        public static interface WithIsEnabled {
            public Update withIsEnabled(Boolean var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithDescription,
    UpdateStages.WithIsEnabled,
    UpdateStages.WithScopes,
    UpdateStages.WithSources,
    UpdateStages.WithActions {
        public Automation apply();

        public Automation apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithActions {
            public WithCreate withActions(List<AutomationAction> var1);
        }

        public static interface WithSources {
            public WithCreate withSources(List<AutomationSource> var1);
        }

        public static interface WithScopes {
            public WithCreate withScopes(List<AutomationScope> var1);
        }

        public static interface WithIsEnabled {
            public WithCreate withIsEnabled(Boolean var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithDescription,
        WithIsEnabled,
        WithScopes,
        WithSources,
        WithActions {
            public Automation create();

            public Automation create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

