/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.IsEnabled;
import com.azure.resourcemanager.security.models.OperationStatusAutoGenerated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class Extension {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="isEnabled", required=true)
    private IsEnabled isEnabled;
    @JsonProperty(value="additionalExtensionProperties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Object> additionalExtensionProperties;
    @JsonProperty(value="operationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private OperationStatusAutoGenerated operationStatus;
    private static final ClientLogger LOGGER = new ClientLogger(Extension.class);

    public String name() {
        return this.name;
    }

    public Extension withName(String name) {
        this.name = name;
        return this;
    }

    public IsEnabled isEnabled() {
        return this.isEnabled;
    }

    public Extension withIsEnabled(IsEnabled isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public Map<String, Object> additionalExtensionProperties() {
        return this.additionalExtensionProperties;
    }

    public Extension withAdditionalExtensionProperties(Map<String, Object> additionalExtensionProperties) {
        this.additionalExtensionProperties = additionalExtensionProperties;
        return this;
    }

    public OperationStatusAutoGenerated operationStatus() {
        return this.operationStatus;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Extension"));
        }
        if (this.isEnabled() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property isEnabled in model Extension"));
        }
        if (this.operationStatus() != null) {
            this.operationStatus().validate();
        }
    }
}

