/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.GovernanceAssignmentInner;
import com.azure.resourcemanager.security.models.GovernanceAssignmentAdditionalData;
import com.azure.resourcemanager.security.models.GovernanceEmailNotification;
import com.azure.resourcemanager.security.models.RemediationEta;
import java.time.OffsetDateTime;

public interface GovernanceAssignment {
    public String id();

    public String name();

    public String type();

    public String owner();

    public OffsetDateTime remediationDueDate();

    public RemediationEta remediationEta();

    public Boolean isGracePeriod();

    public GovernanceEmailNotification governanceEmailNotification();

    public GovernanceAssignmentAdditionalData additionalData();

    public GovernanceAssignmentInner innerModel();

    public Update update();

    public GovernanceAssignment refresh();

    public GovernanceAssignment refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithAdditionalData {
            public Update withAdditionalData(GovernanceAssignmentAdditionalData var1);
        }

        public static interface WithGovernanceEmailNotification {
            public Update withGovernanceEmailNotification(GovernanceEmailNotification var1);
        }

        public static interface WithIsGracePeriod {
            public Update withIsGracePeriod(Boolean var1);
        }

        public static interface WithRemediationEta {
            public Update withRemediationEta(RemediationEta var1);
        }

        public static interface WithRemediationDueDate {
            public Update withRemediationDueDate(OffsetDateTime var1);
        }

        public static interface WithOwner {
            public Update withOwner(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithOwner,
    UpdateStages.WithRemediationDueDate,
    UpdateStages.WithRemediationEta,
    UpdateStages.WithIsGracePeriod,
    UpdateStages.WithGovernanceEmailNotification,
    UpdateStages.WithAdditionalData {
        public GovernanceAssignment apply();

        public GovernanceAssignment apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithAdditionalData {
            public WithCreate withAdditionalData(GovernanceAssignmentAdditionalData var1);
        }

        public static interface WithGovernanceEmailNotification {
            public WithCreate withGovernanceEmailNotification(GovernanceEmailNotification var1);
        }

        public static interface WithIsGracePeriod {
            public WithCreate withIsGracePeriod(Boolean var1);
        }

        public static interface WithRemediationEta {
            public WithCreate withRemediationEta(RemediationEta var1);
        }

        public static interface WithRemediationDueDate {
            public WithCreate withRemediationDueDate(OffsetDateTime var1);
        }

        public static interface WithOwner {
            public WithCreate withOwner(String var1);
        }

        public static interface WithCreate
        extends WithOwner,
        WithRemediationDueDate,
        WithRemediationEta,
        WithIsGracePeriod,
        WithGovernanceEmailNotification,
        WithAdditionalData {
            public GovernanceAssignment create();

            public GovernanceAssignment create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAssessment(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

