/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class Issue {
    @JsonProperty(value="issueKey", required=true)
    private String issueKey;
    @JsonProperty(value="issueName")
    private String issueName;
    @JsonProperty(value="securityValues")
    private List<String> securityValues;
    @JsonProperty(value="issueDescription")
    private String issueDescription;
    @JsonProperty(value="remediationSteps")
    private String remediationSteps;
    @JsonProperty(value="remediationScript")
    private String remediationScript;
    @JsonProperty(value="issueAdditionalData")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> issueAdditionalData;
    private static final ClientLogger LOGGER = new ClientLogger(Issue.class);

    public String issueKey() {
        return this.issueKey;
    }

    public Issue withIssueKey(String issueKey) {
        this.issueKey = issueKey;
        return this;
    }

    public String issueName() {
        return this.issueName;
    }

    public Issue withIssueName(String issueName) {
        this.issueName = issueName;
        return this;
    }

    public List<String> securityValues() {
        return this.securityValues;
    }

    public Issue withSecurityValues(List<String> securityValues) {
        this.securityValues = securityValues;
        return this;
    }

    public String issueDescription() {
        return this.issueDescription;
    }

    public Issue withIssueDescription(String issueDescription) {
        this.issueDescription = issueDescription;
        return this;
    }

    public String remediationSteps() {
        return this.remediationSteps;
    }

    public Issue withRemediationSteps(String remediationSteps) {
        this.remediationSteps = remediationSteps;
        return this;
    }

    public String remediationScript() {
        return this.remediationScript;
    }

    public Issue withRemediationScript(String remediationScript) {
        this.remediationScript = remediationScript;
        return this;
    }

    public Map<String, String> issueAdditionalData() {
        return this.issueAdditionalData;
    }

    public Issue withIssueAdditionalData(Map<String, String> issueAdditionalData) {
        this.issueAdditionalData = issueAdditionalData;
        return this;
    }

    public void validate() {
        if (this.issueKey() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property issueKey in model Issue"));
        }
    }
}

