/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.Protocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class JitNetworkAccessPortRule {
    @JsonProperty(value="number", required=true)
    private int number;
    @JsonProperty(value="protocol", required=true)
    private Protocol protocol;
    @JsonProperty(value="allowedSourceAddressPrefix")
    private String allowedSourceAddressPrefix;
    @JsonProperty(value="allowedSourceAddressPrefixes")
    private List<String> allowedSourceAddressPrefixes;
    @JsonProperty(value="maxRequestAccessDuration", required=true)
    private String maxRequestAccessDuration;
    private static final ClientLogger LOGGER = new ClientLogger(JitNetworkAccessPortRule.class);

    public int number() {
        return this.number;
    }

    public JitNetworkAccessPortRule withNumber(int number) {
        this.number = number;
        return this;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public JitNetworkAccessPortRule withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String allowedSourceAddressPrefix() {
        return this.allowedSourceAddressPrefix;
    }

    public JitNetworkAccessPortRule withAllowedSourceAddressPrefix(String allowedSourceAddressPrefix) {
        this.allowedSourceAddressPrefix = allowedSourceAddressPrefix;
        return this;
    }

    public List<String> allowedSourceAddressPrefixes() {
        return this.allowedSourceAddressPrefixes;
    }

    public JitNetworkAccessPortRule withAllowedSourceAddressPrefixes(List<String> allowedSourceAddressPrefixes) {
        this.allowedSourceAddressPrefixes = allowedSourceAddressPrefixes;
        return this;
    }

    public String maxRequestAccessDuration() {
        return this.maxRequestAccessDuration;
    }

    public JitNetworkAccessPortRule withMaxRequestAccessDuration(String maxRequestAccessDuration) {
        this.maxRequestAccessDuration = maxRequestAccessDuration;
        return this;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property protocol in model JitNetworkAccessPortRule"));
        }
        if (this.maxRequestAccessDuration() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property maxRequestAccessDuration in model JitNetworkAccessPortRule"));
        }
    }
}

