/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.Status;
import com.azure.resourcemanager.security.models.StatusReason;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class JitNetworkAccessRequestPort {
    @JsonProperty(value="number", required=true)
    private int number;
    @JsonProperty(value="allowedSourceAddressPrefix")
    private String allowedSourceAddressPrefix;
    @JsonProperty(value="allowedSourceAddressPrefixes")
    private List<String> allowedSourceAddressPrefixes;
    @JsonProperty(value="endTimeUtc", required=true)
    private OffsetDateTime endTimeUtc;
    @JsonProperty(value="status", required=true)
    private Status status;
    @JsonProperty(value="statusReason", required=true)
    private StatusReason statusReason;
    @JsonProperty(value="mappedPort")
    private Integer mappedPort;
    private static final ClientLogger LOGGER = new ClientLogger(JitNetworkAccessRequestPort.class);

    public int number() {
        return this.number;
    }

    public JitNetworkAccessRequestPort withNumber(int number) {
        this.number = number;
        return this;
    }

    public String allowedSourceAddressPrefix() {
        return this.allowedSourceAddressPrefix;
    }

    public JitNetworkAccessRequestPort withAllowedSourceAddressPrefix(String allowedSourceAddressPrefix) {
        this.allowedSourceAddressPrefix = allowedSourceAddressPrefix;
        return this;
    }

    public List<String> allowedSourceAddressPrefixes() {
        return this.allowedSourceAddressPrefixes;
    }

    public JitNetworkAccessRequestPort withAllowedSourceAddressPrefixes(List<String> allowedSourceAddressPrefixes) {
        this.allowedSourceAddressPrefixes = allowedSourceAddressPrefixes;
        return this;
    }

    public OffsetDateTime endTimeUtc() {
        return this.endTimeUtc;
    }

    public JitNetworkAccessRequestPort withEndTimeUtc(OffsetDateTime endTimeUtc) {
        this.endTimeUtc = endTimeUtc;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public JitNetworkAccessRequestPort withStatus(Status status) {
        this.status = status;
        return this;
    }

    public StatusReason statusReason() {
        return this.statusReason;
    }

    public JitNetworkAccessRequestPort withStatusReason(StatusReason statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    public Integer mappedPort() {
        return this.mappedPort;
    }

    public JitNetworkAccessRequestPort withMappedPort(Integer mappedPort) {
        this.mappedPort = mappedPort;
        return this;
    }

    public void validate() {
        if (this.endTimeUtc() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property endTimeUtc in model JitNetworkAccessRequestPort"));
        }
        if (this.status() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property status in model JitNetworkAccessRequestPort"));
        }
        if (this.statusReason() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property statusReason in model JitNetworkAccessRequestPort"));
        }
    }
}

