/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentMetadataProperties;
import com.azure.resourcemanager.security.models.AssessmentLinks;
import com.azure.resourcemanager.security.models.ResourceDetails;
import com.azure.resourcemanager.security.models.SecurityAssessmentPartnerData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class SecurityAssessmentPropertiesBase {
    @JsonProperty(value="resourceDetails", required=true)
    private ResourceDetails resourceDetails;
    @JsonProperty(value="displayName", access=JsonProperty.Access.WRITE_ONLY)
    private String displayName;
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> additionalData;
    @JsonProperty(value="links", access=JsonProperty.Access.WRITE_ONLY)
    private AssessmentLinks links;
    @JsonProperty(value="metadata")
    private SecurityAssessmentMetadataProperties metadata;
    @JsonProperty(value="partnersData")
    private SecurityAssessmentPartnerData partnersData;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityAssessmentPropertiesBase.class);

    public ResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public SecurityAssessmentPropertiesBase withResourceDetails(ResourceDetails resourceDetails) {
        this.resourceDetails = resourceDetails;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public Map<String, String> additionalData() {
        return this.additionalData;
    }

    public SecurityAssessmentPropertiesBase withAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public AssessmentLinks links() {
        return this.links;
    }

    public SecurityAssessmentMetadataProperties metadata() {
        return this.metadata;
    }

    public SecurityAssessmentPropertiesBase withMetadata(SecurityAssessmentMetadataProperties metadata) {
        this.metadata = metadata;
        return this;
    }

    public SecurityAssessmentPartnerData partnersData() {
        return this.partnersData;
    }

    public SecurityAssessmentPropertiesBase withPartnersData(SecurityAssessmentPartnerData partnersData) {
        this.partnersData = partnersData;
        return this;
    }

    public void validate() {
        if (this.resourceDetails() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property resourceDetails in model SecurityAssessmentPropertiesBase"));
        }
        this.resourceDetails().validate();
        if (this.links() != null) {
            this.links().validate();
        }
        if (this.metadata() != null) {
            this.metadata().validate();
        }
        if (this.partnersData() != null) {
            this.partnersData().validate();
        }
    }
}

