/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.SecurityConnectorInner;
import com.azure.resourcemanager.security.models.CloudName;
import com.azure.resourcemanager.security.models.CloudOffering;
import com.azure.resourcemanager.security.models.EnvironmentData;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface SecurityConnector {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public String hierarchyIdentifier();

    public OffsetDateTime hierarchyIdentifierTrialEndDate();

    public CloudName environmentName();

    public List<CloudOffering> offerings();

    public EnvironmentData environmentData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public SecurityConnectorInner innerModel();

    public Update update();

    public SecurityConnector refresh();

    public SecurityConnector refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithEnvironmentData {
            public Update withEnvironmentData(EnvironmentData var1);
        }

        public static interface WithOfferings {
            public Update withOfferings(List<CloudOffering> var1);
        }

        public static interface WithEnvironmentName {
            public Update withEnvironmentName(CloudName var1);
        }

        public static interface WithHierarchyIdentifier {
            public Update withHierarchyIdentifier(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithHierarchyIdentifier,
    UpdateStages.WithEnvironmentName,
    UpdateStages.WithOfferings,
    UpdateStages.WithEnvironmentData {
        public SecurityConnector apply();

        public SecurityConnector apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEnvironmentData {
            public WithCreate withEnvironmentData(EnvironmentData var1);
        }

        public static interface WithOfferings {
            public WithCreate withOfferings(List<CloudOffering> var1);
        }

        public static interface WithEnvironmentName {
            public WithCreate withEnvironmentName(CloudName var1);
        }

        public static interface WithHierarchyIdentifier {
            public WithCreate withHierarchyIdentifier(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithHierarchyIdentifier,
        WithEnvironmentName,
        WithOfferings,
        WithEnvironmentData {
            public SecurityConnector create();

            public SecurityConnector create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

