/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.fluent.models.SecuritySolutionsReferenceDataProperties;
import com.azure.resourcemanager.security.models.SecurityFamily;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SecuritySolutionsReferenceData
extends ProxyResource {
    @JsonProperty(value="properties", required=true)
    private SecuritySolutionsReferenceDataProperties innerProperties = new SecuritySolutionsReferenceDataProperties();
    @JsonProperty(value="location", access=JsonProperty.Access.WRITE_ONLY)
    private String location;
    private static final ClientLogger LOGGER = new ClientLogger(SecuritySolutionsReferenceData.class);

    private SecuritySolutionsReferenceDataProperties innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public SecurityFamily securityFamily() {
        return this.innerProperties() == null ? null : this.innerProperties().securityFamily();
    }

    public SecuritySolutionsReferenceData withSecurityFamily(SecurityFamily securityFamily) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecuritySolutionsReferenceDataProperties();
        }
        this.innerProperties().withSecurityFamily(securityFamily);
        return this;
    }

    public String alertVendorName() {
        return this.innerProperties() == null ? null : this.innerProperties().alertVendorName();
    }

    public SecuritySolutionsReferenceData withAlertVendorName(String alertVendorName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecuritySolutionsReferenceDataProperties();
        }
        this.innerProperties().withAlertVendorName(alertVendorName);
        return this;
    }

    public String packageInfoUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().packageInfoUrl();
    }

    public SecuritySolutionsReferenceData withPackageInfoUrl(String packageInfoUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecuritySolutionsReferenceDataProperties();
        }
        this.innerProperties().withPackageInfoUrl(packageInfoUrl);
        return this;
    }

    public String productName() {
        return this.innerProperties() == null ? null : this.innerProperties().productName();
    }

    public SecuritySolutionsReferenceData withProductName(String productName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecuritySolutionsReferenceDataProperties();
        }
        this.innerProperties().withProductName(productName);
        return this;
    }

    public String publisher() {
        return this.innerProperties() == null ? null : this.innerProperties().publisher();
    }

    public SecuritySolutionsReferenceData withPublisher(String publisher) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecuritySolutionsReferenceDataProperties();
        }
        this.innerProperties().withPublisher(publisher);
        return this;
    }

    public String publisherDisplayName() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherDisplayName();
    }

    public SecuritySolutionsReferenceData withPublisherDisplayName(String publisherDisplayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecuritySolutionsReferenceDataProperties();
        }
        this.innerProperties().withPublisherDisplayName(publisherDisplayName);
        return this;
    }

    public String template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    public SecuritySolutionsReferenceData withTemplate(String template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecuritySolutionsReferenceDataProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SecuritySolutionsReferenceData"));
        }
        this.innerProperties().validate();
    }
}

