/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.jsonrpc;

import com.azure.autorest.extension.base.jsonrpc.CallerResponse;
import com.azure.autorest.extension.base.jsonrpc.PeekingBinaryReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Connection {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private OutputStream writer;
    private PeekingBinaryReader reader;
    private boolean isDisposed = false;
    private final AtomicInteger requestId;
    private final Map<Integer, CallerResponse<?>> tasks = new ConcurrentHashMap();
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final CompletableFuture<Void> loop;
    private final Map<String, Function<JsonNode, String>> dispatch = new HashMap<String, Function<JsonNode, String>>();
    private boolean isAlive = true;
    private final Semaphore streamReady = new Semaphore(1);

    public Connection(OutputStream writer, InputStream input) {
        this.writer = writer;
        this.reader = new PeekingBinaryReader(input);
        this.loop = CompletableFuture.runAsync(this::listen);
        this.requestId = new AtomicInteger(0);
    }

    public void stop() {
        this.isAlive = false;
        this.loop.cancel(true);
    }

    private JsonNode readJson() {
        Object jsonText = "";
        while (true) {
            try {
                jsonText = (String)jsonText + this.reader.readAsciiLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read JSON input");
            }
            try {
                JsonNode json = MAPPER.readTree((String)jsonText);
                if (json == null) continue;
                return json;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public <T> void dispatch(String path, Supplier<T> method) {
        this.dispatch.put(path, input -> {
            Object result = method.get();
            if (result == null) {
                return "null";
            }
            try {
                return MAPPER.writeValueAsString(result);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private List<JsonNode> readArguments(JsonNode input, int expectedArgs) {
        ArrayList<JsonNode> ret = new ArrayList<JsonNode>();
        if (input instanceof ArrayNode) {
            for (JsonNode jsonNode : input) {
                ret.add(jsonNode);
            }
        } else if (input != null) {
            ret.add(input);
        }
        if (expectedArgs == 0) {
            if (ret.size() == 0) {
                return new ArrayList<JsonNode>();
            }
            throw new RuntimeException("Invalid number of arguments");
        }
        if (ret.size() == expectedArgs) {
            return ret;
        }
        throw new RuntimeException("Invalid number of arguments");
    }

    public void dispatchNotification(String path, Runnable method) {
        this.dispatch.put(path, input -> {
            method.run();
            return null;
        });
    }

    public <P1, T> void dispatch(String path, Function<P1, T> method) {
    }

    public <P1, P2, T> void dispatch(String path, BiFunction<P1, P2, T> method, Class<? extends P1> p1Class, Class<? extends P2> p2Class) {
        this.dispatch.put(path, input -> {
            List<JsonNode> args = this.readArguments((JsonNode)input, 2);
            try {
                Object a1 = MAPPER.treeToValue((TreeNode)args.get(0), p1Class);
                Object a2 = MAPPER.treeToValue((TreeNode)args.get(1), p2Class);
                Object result = method.apply(a1, a2);
                if (result == null) {
                    return "null";
                }
                return MAPPER.writeValueAsString(result);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private JsonNode readJson(int contentLength) {
        try {
            byte[] bytes = this.reader.readBytes(contentLength);
            return MAPPER.readTree(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean listen() {
        while (this.isAlive) {
            try {
                int ch = this.reader.peekByte();
                if (-1 != ch) {
                    if (123 == ch || 91 == ch) {
                        this.process(this.readJson());
                        continue;
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    String line = this.reader.readAsciiLine();
                    while (line != null && !line.isEmpty()) {
                        String[] bits = line.split(":", 2);
                        headers.put(bits[0].trim(), bits[1].trim());
                        line = this.reader.readAsciiLine();
                    }
                    ch = this.reader.peekByte();
                    if (123 == ch || 91 == ch) {
                        if (headers.containsKey("Content-Length")) {
                            String value = (String)headers.get("Content-Length");
                            int contentLength = Integer.parseInt(value);
                            this.process(this.readJson(contentLength));
                            continue;
                        }
                        this.process(this.readJson());
                        continue;
                    }
                    return false;
                }
                break;
            }
            catch (Exception e) {
                if (this.isAlive) continue;
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public void process(JsonNode content) {
        if (content instanceof ObjectNode) {
            this.executorService.submit(() -> {
                ObjectNode jobject = (ObjectNode)content;
                try {
                    Iterator fieldIterator = jobject.fields();
                    while (fieldIterator.hasNext()) {
                        CallerResponse<?> f;
                        int id;
                        Map.Entry field = (Map.Entry)fieldIterator.next();
                        if (((String)field.getKey()).equals("method")) {
                            String method = ((JsonNode)field.getValue()).asText();
                            int id2 = -1;
                            if (jobject.has("id")) {
                                id2 = jobject.get("id").asInt(-1);
                            }
                            if (this.dispatch.containsKey(method)) {
                                Function<JsonNode, String> fn = this.dispatch.get(method);
                                JsonNode parameters = jobject.get("params");
                                String result = fn.apply(parameters);
                                if (id2 != -1) {
                                    this.respond(id2, result);
                                }
                            }
                            return;
                        }
                        if (!((String)field.getKey()).equals("result") || (id = jobject.get("id").asInt(-1)) == -1) continue;
                        Map<Integer, CallerResponse<?>> map = this.tasks;
                        synchronized (map) {
                            f = this.tasks.get(id);
                            this.tasks.remove(id);
                        }
                        if (f.type.getRawClass().equals(Boolean.class) && jobject.get("result") != null && jobject.get("result").toString().equals("{}")) {
                            f.complete(Boolean.TRUE);
                            continue;
                        }
                        if (f.type.getRawClass().equals(String.class) && jobject.get("result") != null && jobject.get("result").toString().equals("{}")) {
                            f.complete("");
                            continue;
                        }
                        f.complete(MAPPER.convertValue((Object)jobject.get("result"), f.type));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if (content instanceof ArrayNode) {
            System.err.println("Unhandled: Batch Request");
        }
    }

    protected void close() throws IOException {
        this.isAlive = false;
        if (!this.isDisposed) {
            this.isDisposed = true;
            for (Map.Entry<Integer, CallerResponse<?>> t : this.tasks.entrySet()) {
                t.getValue().cancel(true);
            }
            this.writer.close();
            this.writer = null;
            this.reader.close();
            this.reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(String text) {
        try {
            Semaphore semaphore = this.streamReady;
            synchronized (semaphore) {
                this.streamReady.acquire();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        byte[] buffer = text.getBytes(StandardCharsets.UTF_8);
        try {
            this.write(("Content-Length: " + buffer.length + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII));
            this.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Semaphore semaphore = this.streamReady;
        synchronized (semaphore) {
            this.streamReady.release();
        }
    }

    private void write(byte[] buffer) throws IOException {
        this.writer.write(buffer, 0, buffer.length);
    }

    public void sendError(int id, int code, String message) {
        JsonNode node = new ObjectNode(MAPPER.getNodeFactory()).put("jsonrpc", "2.0").put("id", id).put("message", message).set("error", (JsonNode)new ObjectNode(MAPPER.getNodeFactory()).put("code", code));
        this.send(node.toString());
    }

    public void respond(int id, String value) {
        JsonNode node;
        try {
            node = new ObjectNode(MAPPER.getNodeFactory()).put("jsonrpc", "2.0").put("id", id).set("result", MAPPER.readTree(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.send(node.toString());
    }

    public void notify(String methodName, Object ... values) {
        ObjectNode node = new ObjectNode(MAPPER.getNodeFactory()).put("jsonrpc", "2.0").put("method", methodName);
        if (values != null && values.length > 0) {
            node = node.set("params", (JsonNode)new ArrayNode(MAPPER.getNodeFactory(), Arrays.stream(values).map(o -> (JsonNode)MAPPER.convertValue(o, JsonNode.class)).collect(Collectors.toList())));
        }
        this.send(node.toString());
    }

    public void notifyWithObject(String methodName, Object parameter) {
        ObjectNode node = new ObjectNode(MAPPER.getNodeFactory()).put("jsonrpc", "2.0").put("method", methodName);
        if (parameter != null) {
            node = node.set("params", (JsonNode)MAPPER.convertValue(parameter, JsonNode.class));
        }
        this.send(node.toString());
    }

    public <T> T request(JavaType type, String methodName, Object ... values) {
        int id = this.requestId.getAndIncrement();
        CallerResponse response = new CallerResponse(id, type);
        this.tasks.put(id, response);
        ObjectNode node = new ObjectNode(MAPPER.getNodeFactory()).put("jsonrpc", "2.0").put("method", methodName).put("id", id);
        if (values != null && values.length > 0) {
            node = node.set("params", (JsonNode)new ArrayNode(MAPPER.getNodeFactory(), Arrays.stream(values).map(o -> (JsonNode)MAPPER.convertValue(o, JsonNode.class)).collect(Collectors.toList())));
        }
        this.send(node.toString());
        try {
            return response.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T requestWithObject(JavaType type, String methodName, Object parameter) {
        int id = this.requestId.getAndIncrement();
        CallerResponse response = new CallerResponse(id, type);
        this.tasks.put(id, response);
        ObjectNode node = new ObjectNode(MAPPER.getNodeFactory()).put("jsonrpc", "2.0").put("method", methodName).put("id", id);
        if (parameter != null) {
            node = node.set("params", (JsonNode)MAPPER.convertValue(parameter, JsonNode.class));
        }
        this.send(node.toString());
        try {
            return response.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void batch(List<String> calls) {
        this.send(new ArrayNode(MAPPER.getNodeFactory(), calls.stream().map(s -> {
            try {
                return MAPPER.readTree(s);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList())).toString());
    }

    public void waitForAll() {
        try {
            this.loop.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

