/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.jsonrpc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

class PeekingBinaryReader
implements Closeable {
    Integer lastByte = null;
    InputStream input;

    PeekingBinaryReader(InputStream input) {
        this.input = input;
    }

    int readByte() throws IOException {
        if (this.lastByte != null) {
            int result = this.lastByte;
            this.lastByte = null;
            return result;
        }
        return this.input.read();
    }

    int peekByte() throws IOException {
        if (this.lastByte != null) {
            return this.lastByte;
        }
        int result = this.readByte();
        if (result != -1) {
            this.lastByte = result;
        }
        return result;
    }

    byte[] readBytes(int count) throws IOException {
        byte[] buffer = new byte[count];
        int read = 0;
        if (count > 0 && this.lastByte != null) {
            buffer[read++] = (byte)this.lastByte.intValue();
            this.lastByte = null;
        }
        while (read < count) {
            read += this.input.read(buffer, read, count - read);
        }
        return buffer;
    }

    String readAsciiLine() throws IOException {
        StringBuilder result = new StringBuilder();
        int c = this.readByte();
        while (c != 13 && c != 10 && c != -1) {
            result.append((char)c);
            c = this.readByte();
        }
        if (c == 13 && this.peekByte() == 10) {
            this.readByte();
        }
        if (c == -1 && result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

