/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.jsonrpc;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ProtocolUtils {
    private static final List<Class<?>> PRIMITIVES = Arrays.asList(Boolean.class, Integer.class, Float.class, Double.class, Short.class, Long.class, Byte.class, Character.class);

    public static boolean isPrimitive(Object value) {
        Objects.requireNonNull(value);
        return PRIMITIVES.stream().anyMatch(type -> type.isAssignableFrom(value.getClass()));
    }

    public static String quote(Object value) {
        if (value == null) {
            return "null";
        }
        String input = value.toString();
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\u0000", "\\0").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static String quote(boolean value) {
        return Boolean.toString(value).toLowerCase();
    }

    public static String quote(int value) {
        return Integer.toString(value).toLowerCase();
    }

    public static String quote(float value) {
        return Float.toString(value).toLowerCase();
    }

    public static String quote(double value) {
        return Double.toString(value).toLowerCase();
    }

    public static String quote(short value) {
        return Short.toString(value).toLowerCase();
    }

    public static String quote(long value) {
        return Long.toString(value).toLowerCase();
    }

    public static String quote(byte value) {
        return Byte.toString(value).toLowerCase();
    }

    public static String quote(char value) {
        return Character.toString(value).toLowerCase();
    }
}

