/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.model.codemodel;

import java.util.HashMap;
import java.util.Map;

public enum KnownMediaType {
    BINARY("binary"),
    FORM("form"),
    JSON("json"),
    MULTIPART("multipart"),
    TEXT("text"),
    UNKNOWN("unknown"),
    XML("xml");

    private final String value;
    private static final Map<String, KnownMediaType> CONSTANTS;

    private KnownMediaType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public static KnownMediaType fromValue(String value) {
        KnownMediaType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public String getContentType() {
        switch (this.ordinal()) {
            case 0: {
                return "application/octet-stream";
            }
            case 1: {
                return "application/x-www-form-urlencoded";
            }
            case 2: {
                return "application/json";
            }
            case 3: {
                return "multipart/form-data";
            }
            case 4: {
                return "text/plain";
            }
            case 6: {
                return "application/xml";
            }
        }
        return JSON.getContentType();
    }

    static {
        CONSTANTS = new HashMap<String, KnownMediaType>();
        for (KnownMediaType c : KnownMediaType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

