/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.model.codemodel;

import com.azure.autorest.extension.base.model.codemodel.Operation;
import com.azure.autorest.extension.base.model.codemodel.Property;
import com.azure.autorest.extension.base.model.codemodel.Value;
import java.util.HashMap;
import java.util.Map;

public class Parameter
extends Value {
    private String clientDefaultValue;
    private ImplementationLocation implementation;
    private Operation operation;
    private boolean flattened = false;
    private Parameter originalParameter;
    private Parameter groupedBy;
    private Property targetProperty;
    private String origin;
    private String summary;

    public String getClientDefaultValue() {
        return this.clientDefaultValue;
    }

    public void setClientDefaultValue(String clientDefaultValue) {
        this.clientDefaultValue = clientDefaultValue;
    }

    public ImplementationLocation getImplementation() {
        return this.implementation;
    }

    public void setImplementation(ImplementationLocation implementation) {
        this.implementation = implementation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public void setFlattened(boolean hidden) {
        this.flattened = hidden;
    }

    public Parameter getOriginalParameter() {
        return this.originalParameter;
    }

    public void setOriginalParameter(Parameter originalParameter) {
        this.originalParameter = originalParameter;
    }

    public Property getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(Property targetProperty) {
        this.targetProperty = targetProperty;
    }

    public Parameter getGroupedBy() {
        return this.groupedBy;
    }

    public void setGroupedBy(Parameter groupedBy) {
        this.groupedBy = groupedBy;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    public static enum ImplementationLocation {
        CLIENT("Client"),
        CONTEXT("Context"),
        METHOD("Method");

        private final String value;
        private static final Map<String, ImplementationLocation> CONSTANTS;

        private ImplementationLocation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static ImplementationLocation fromValue(String value) {
            ImplementationLocation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ImplementationLocation>();
            for (ImplementationLocation c : ImplementationLocation.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

