/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.model.codemodel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Scheme {
    private SecuritySchemeType type;
    private Set<String> scopes = new HashSet<String>();
    private String name;
    private String in;
    private String prefix;

    public SecuritySchemeType getType() {
        return this.type;
    }

    public void setType(SecuritySchemeType type) {
        this.type = type;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIn() {
        return this.in;
    }

    public void setIn(String in) {
        this.in = in;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public static enum SecuritySchemeType {
        OAUTH2("OAuth2"),
        KEY("Key");

        private final String value;
        private static final Map<String, SecuritySchemeType> CONSTANTS;

        private SecuritySchemeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static SecuritySchemeType fromValue(String value) {
            SecuritySchemeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SecuritySchemeType>();
            for (SecuritySchemeType c : SecuritySchemeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

