/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.model.codemodel;

import java.util.HashMap;
import java.util.Map;

public enum SerializationStyle {
    BINARY("binary"),
    DEEP_OBJECT("deepObject"),
    FORM("form"),
    JSON("json"),
    LABEL("label"),
    MATRIX("matrix"),
    PIPE_DELIMITED("pipeDelimited"),
    SIMPLE("simple"),
    SPACE_DELIMITED("spaceDelimited"),
    TAB_DELIMITED("tabDelimited"),
    XML("xml");

    private final String value;
    private static final Map<String, SerializationStyle> CONSTANTS;

    public int getValue() {
        return this.ordinal();
    }

    private SerializationStyle(String value) {
        this.value = value;
    }

    public String toString() {
        if ("uri".equals(this.value)) {
            return "host";
        }
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public static SerializationStyle fromValue(String value) {
        SerializationStyle constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SerializationStyle>();
        for (SerializationStyle c : SerializationStyle.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

