/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.plugin;

import com.azure.autorest.extension.base.plugin.AutorestSettings;
import com.azure.autorest.extension.base.plugin.NewPlugin;
import com.azure.autorest.extension.base.plugin.PluginLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class JavaSettings {
    private static final String VERSION = "4.0.0";
    private static JavaSettings instance;
    private static NewPlugin host;
    private static String header;
    private static final Map<String, Object> SIMPLE_JAVA_SETTINGS;
    private static Logger logger;
    private final boolean useKeyCredential;
    private final boolean branded;
    private boolean noCustomHeaders;
    private final String keyCredentialHeaderName;
    private Set<CredentialType> credentialTypes;
    private Set<String> credentialScopes;
    private final boolean azure;
    private final String artifactId;
    private final boolean urlAsString;
    private final boolean disableRequiredJsonAnnotation;
    private final Fluent fluent;
    private final ClientFlattenAnnotationTarget clientFlattenAnnotationTarget;
    private final ModelerSettings modelerSettings;
    private final AutorestSettings autorestSettings;
    private final boolean sdkIntegration;
    private final boolean regeneratePom;
    private final String fileHeaderText;
    private final int maximumJavadocCommentWidth;
    private final String serviceName;
    private final String packageName;
    private final boolean shouldGenerateXmlSerialization;
    private final boolean nonNullAnnotations;
    private final boolean clientSideValidations;
    private final String clientTypePrefix;
    private final boolean generateClientInterfaces;
    private final boolean generateClientAsImpl;
    private final String implementationSubpackage;
    private final String modelsSubpackage;
    private final String fluentSubpackage;
    private final boolean requiredParameterClientMethods;
    private final boolean generateSyncAsyncClients;
    private final SyncMethodsGeneration syncMethods;
    private final boolean requiredFieldsAsConstructorArgs;
    private final boolean serviceInterfaceAsPublic;
    private final List<String> customTypes;
    private final String customTypesSubpackage;
    private final boolean clientLogger;
    private final String customizationJarPath;
    private final String customizationClass;
    boolean skipFormatting;
    private final boolean optionalConstantAsEnum;
    private final boolean dataPlaneClient;
    private final boolean useIterable;
    private final List<String> serviceVersions;
    private final boolean requireXMsFlattenedToFlatten;
    private final boolean generateSamples;
    private final boolean generateTests;
    private final boolean generateSendRequestMethod;
    private final boolean generateModels;
    private final boolean syncStackEnabled;
    private final boolean clientBuilderDisabled;
    private final boolean outputModelImmutable;
    private final boolean pageSizeEnabled;
    private final boolean generateGraalVmConfig;
    private final Map<String, PollingDetails> pollingConfig;
    private final boolean passDiscriminatorToChildDeserialization;
    private final boolean annotateGettersAndSettersForSerialization;
    private final String defaultHttpExceptionType;
    private final boolean useDefaultHttpStatusCodeToExceptionTypeMapping;
    private final Map<Integer, String> httpStatusCodeToExceptionTypeMapping;
    private final boolean generateBuilderPerClient;
    private final boolean handlePartialUpdate;
    private final boolean genericResponseTypes;
    private final boolean streamStyleSerialization;
    private final boolean isInputStreamForBinary;
    private final boolean includeReadOnlyInConstructorArgs;
    private final boolean nullByteArrayMapsToEmptyArray;
    private static final String DEFAULT_CODE_GENERATION_HEADER;
    private static final String DEFAULT_CODE_GENERATION_HEADER_WITHOUT_VERSION;
    private static final String MICROSOFT_APACHE_LICENSE_HEADER;
    private static final String MICROSOFT_MIT_LICENSE_HEADER;
    private static final String MICROSOFT_MIT_SMALL_LICENSE_HEADER;

    static void setHeader(String value) {
        header = "MICROSOFT_MIT".equals(value) ? MICROSOFT_MIT_LICENSE_HEADER + "\n" + String.format(DEFAULT_CODE_GENERATION_HEADER, VERSION) : ("MICROSOFT_APACHE".equals(value) ? MICROSOFT_APACHE_LICENSE_HEADER + "\n" + String.format(DEFAULT_CODE_GENERATION_HEADER, VERSION) : ("MICROSOFT_MIT_NO_VERSION".equals(value) ? MICROSOFT_MIT_LICENSE_HEADER + "\n" + DEFAULT_CODE_GENERATION_HEADER_WITHOUT_VERSION : ("MICROSOFT_MIT_SMALL_NO_VERSION".equals(value) ? MICROSOFT_MIT_SMALL_LICENSE_HEADER + "\n" + DEFAULT_CODE_GENERATION_HEADER_WITHOUT_VERSION : ("MICROSOFT_APACHE_NO_VERSION".equals(value) ? MICROSOFT_APACHE_LICENSE_HEADER + "\n" + DEFAULT_CODE_GENERATION_HEADER_WITHOUT_VERSION : ("MICROSOFT_MIT_NO_CODEGEN".equals(value) ? MICROSOFT_MIT_LICENSE_HEADER + "\nCode generated by Microsoft (R) AutoRest Code Generator." : ("NONE".equals(value) ? "" : ("MICROSOFT_MIT_SMALL".equals(value) ? MICROSOFT_MIT_SMALL_LICENSE_HEADER + "Code generated by Microsoft (R) AutoRest Code Generator." : ("MICROSOFT_MIT_SMALL_TYPESPEC".equals(value) ? MICROSOFT_MIT_SMALL_LICENSE_HEADER + "Code generated by Microsoft (R) TypeSpec Code Generator." : ("SMALL_TYPESPEC".equals(value) ? "Code generated by Microsoft (R) TypeSpec Code Generator." : ("MICROSOFT_MIT_SMALL_NO_CODEGEN".equals(value) ? MICROSOFT_MIT_SMALL_LICENSE_HEADER : value))))))))));
    }

    static void setHost(NewPlugin host) {
        JavaSettings.host = host;
        logger = new PluginLogger(host, JavaSettings.class, new String[0]);
    }

    public static void clear() {
        instance = null;
    }

    public static JavaSettings getInstance() {
        if (instance == null) {
            List require;
            AutorestSettings autorestSettings = new AutorestSettings();
            JavaSettings.loadStringSetting("title", autorestSettings::setTitle);
            JavaSettings.loadStringOrArraySettingAsArray("security", autorestSettings::setSecurity);
            JavaSettings.loadStringOrArraySettingAsArray("security-scopes", autorestSettings::setSecurityScopes);
            JavaSettings.loadStringSetting("security-header-name", autorestSettings::setSecurityHeaderName);
            JavaSettings.loadStringSetting("tag", autorestSettings::setTag);
            JavaSettings.loadStringSetting("base-folder", autorestSettings::setBaseFolder);
            JavaSettings.loadStringSetting("output-folder", autorestSettings::setOutputFolder);
            JavaSettings.loadStringSetting("java-sdks-folder", autorestSettings::setJavaSdksFolder);
            List inputFiles = (List)host.getValue((Type)((Object)List.class), "input-file");
            if (inputFiles != null) {
                autorestSettings.getInputFiles().addAll(inputFiles.stream().map(Object::toString).collect(Collectors.toList()));
                logger.debug("List of input files : {}", autorestSettings.getInputFiles());
            }
            if ((require = (List)host.getValue((Type)((Object)List.class), "require")) != null) {
                autorestSettings.getRequire().addAll(require.stream().map(Object::toString).collect(Collectors.toList()));
                logger.debug("List of require : {}", autorestSettings.getRequire());
            }
            JavaSettings.setHeader(JavaSettings.getStringValue(host, "license-header"));
            instance = new JavaSettings(autorestSettings, (Map)host.getValue(new TypeReference<Map<String, Object>>(){}.getType(), "modelerfour"), JavaSettings.getBooleanValue(host, "azure-arm", false), JavaSettings.getBooleanValue(host, "sdk-integration", false), JavaSettings.getStringValue(host, "fluent"), JavaSettings.getBooleanValue(host, "regenerate-pom", false), header, 120, JavaSettings.getStringValue(host, "service-name"), JavaSettings.getStringValue(host, "namespace", "com.mycompany.app").toLowerCase(), JavaSettings.getBooleanValue(host, "enable-xml", false), JavaSettings.getBooleanValue(host, "non-null-annotations", false), JavaSettings.getBooleanValue(host, "client-side-validations", false), JavaSettings.getStringValue(host, "client-type-prefix"), JavaSettings.getBooleanValue(host, "generate-client-interfaces", false), JavaSettings.getBooleanValue(host, "generate-client-as-impl", false), JavaSettings.getStringValue(host, "implementation-subpackage", "implementation"), JavaSettings.getStringValue(host, "models-subpackage", "models"), JavaSettings.getStringValue(host, "custom-types", ""), JavaSettings.getStringValue(host, "custom-types-subpackage", ""), JavaSettings.getStringValue(host, "fluent-subpackage", "fluent"), JavaSettings.getBooleanValue(host, "required-parameter-client-methods", false), JavaSettings.getBooleanValue(host, "generate-sync-async-clients", false), JavaSettings.getBooleanValue(host, "generate-builder-per-client", false), JavaSettings.getStringValue(host, "sync-methods", "essential"), JavaSettings.getBooleanValue(host, "client-logger", false), JavaSettings.getBooleanValue(host, "required-fields-as-ctor-args", false), JavaSettings.getBooleanValue(host, "service-interface-as-public", true), JavaSettings.getStringValue(host, "artifact-id", ""), JavaSettings.getStringValue(host, "credential-types", "none"), JavaSettings.getStringValue(host, "credential-scopes"), JavaSettings.getStringValue(host, "customization-jar-path"), JavaSettings.getStringValue(host, "customization-class"), JavaSettings.getBooleanValue(host, "optional-constant-as-enum", false), JavaSettings.getBooleanValue(host, "data-plane", false), JavaSettings.getBooleanValue(host, "use-iterable", false), (List)host.getValue((Type)((Object)List.class), "service-versions"), JavaSettings.getBooleanValue(host, "require-x-ms-flattened-to-flatten", false), JavaSettings.getStringValue(host, "client-flattened-annotation-target", ""), JavaSettings.getStringValue(host, "key-credential-header-name", ""), JavaSettings.getBooleanValue(host, "disable-client-builder", false), JavaSettings.getBooleanValue(host, "skip-formatting", false), (Map)host.getValue(new TypeReference<Map<String, PollingDetails>>(){}.getType(), "polling"), JavaSettings.getBooleanValue(host, "generate-samples", false), JavaSettings.getBooleanValue(host, "generate-tests", false), false, JavaSettings.getBooleanValue(host, "generate-models", false), JavaSettings.getBooleanValue(host, "pass-discriminator-to-child-deserialization", false), JavaSettings.getBooleanValue(host, "annotate-getters-and-setters-for-serialization", false), JavaSettings.getStringValue(host, "default-http-exception-type"), JavaSettings.getBooleanValue(host, "use-default-http-status-code-to-exception-type-mapping", false), (Map)host.getValue(new TypeReference<Map<Integer, String>>(){}.getType(), "http-status-code-to-exception-type-mapping"), JavaSettings.getBooleanValue(host, "partial-update", false), JavaSettings.getBooleanValue(host, "generic-response-type", false), JavaSettings.getBooleanValue(host, "stream-style-serialization", false), JavaSettings.getBooleanValue(host, "enable-sync-stack", false), JavaSettings.getBooleanValue(host, "output-model-immutable", false), JavaSettings.getBooleanValue(host, "use-input-stream-for-binary", false), JavaSettings.getBooleanValue(host, "no-custom-headers", false), JavaSettings.getBooleanValue(host, "include-read-only-in-constructor-args", false), JavaSettings.getBooleanValue(host, "url-as-string", true), JavaSettings.getBooleanValue(host, "disable-required-property-annotation", false), JavaSettings.getBooleanValue(host, "enable-page-size", false), JavaSettings.getBooleanValue(host, "use-key-credential", false), JavaSettings.getBooleanValue(host, "null-byte-array-maps-to-empty-array", false), JavaSettings.getBooleanValue(host, "graal-vm-config", false), JavaSettings.getBooleanValue(host, "branded", true));
        }
        return instance;
    }

    private JavaSettings(AutorestSettings autorestSettings, Map<String, Object> modelerSettings, boolean azure, boolean sdkIntegration, String fluent, boolean regeneratePom, String fileHeaderText, int maximumJavadocCommentWidth, String serviceName, String packageKeyword, boolean shouldGenerateXmlSerialization, boolean nonNullAnnotations, boolean clientSideValidations, String clientTypePrefix, boolean generateClientInterfaces, boolean generateClientAsImpl, String implementationSubpackage, String modelsSubpackage, String customTypes, String customTypesSubpackage, String fluentSubpackage, boolean requiredParameterClientMethods, boolean generateSyncAsyncClients, boolean generateBuilderPerClient, String syncMethods, boolean clientLogger, boolean requiredFieldsAsConstructorArgs, boolean serviceInterfaceAsPublic, String artifactId, String credentialType, String credentialScopes, String customizationJarPath, String customizationClass, boolean optionalConstantAsEnum, boolean dataPlaneClient, boolean useIterable, List<String> serviceVersions, boolean requireXMsFlattenedToFlatten, String clientFlattenAnnotationTarget, String keyCredentialHeaderName, boolean clientBuilderDisabled, boolean skipFormatting, Map<String, PollingDetails> pollingConfig, boolean generateSamples, boolean generateTests, boolean generateSendRequestMethod, boolean generateModels, boolean passDiscriminatorToChildDeserialization, boolean annotateGettersAndSettersForSerialization, String defaultHttpExceptionType, boolean useDefaultHttpStatusCodeToExceptionTypeMapping, Map<Integer, String> httpStatusCodeToExceptionTypeMapping, boolean handlePartialUpdate, boolean genericResponseTypes, boolean streamStyleSerialization, boolean isSyncStackEnabled, boolean outputModelImmutable, boolean streamResponseInputStream, boolean noCustomHeaders, boolean includeReadOnlyInConstructorArgs, boolean urlAsString, boolean disableRequiredPropertyAnnotation, boolean pageSizeEnabled, boolean useKeyCredential, boolean nullByteArrayMapsToEmptyArray, boolean generateGraalVmConfig, boolean branded) {
        String[] splits;
        this.autorestSettings = autorestSettings;
        this.modelerSettings = new ModelerSettings(modelerSettings);
        this.azure = azure;
        this.sdkIntegration = sdkIntegration;
        this.fluent = fluent == null ? Fluent.NONE : (fluent.isEmpty() || fluent.equalsIgnoreCase("true") ? Fluent.PREMIUM : Fluent.valueOf(fluent.toUpperCase(Locale.ROOT)));
        this.regeneratePom = regeneratePom;
        this.fileHeaderText = fileHeaderText;
        this.maximumJavadocCommentWidth = maximumJavadocCommentWidth;
        this.serviceName = serviceName;
        this.packageName = packageKeyword;
        this.shouldGenerateXmlSerialization = shouldGenerateXmlSerialization;
        this.nonNullAnnotations = nonNullAnnotations;
        this.clientSideValidations = clientSideValidations;
        this.clientTypePrefix = clientTypePrefix;
        this.generateClientInterfaces = generateClientInterfaces;
        this.generateClientAsImpl = generateClientAsImpl || generateSyncAsyncClients || generateClientInterfaces;
        this.implementationSubpackage = implementationSubpackage;
        this.modelsSubpackage = modelsSubpackage;
        this.customTypes = customTypes == null || customTypes.isEmpty() ? new ArrayList<String>() : Arrays.asList(customTypes.split(","));
        this.customTypesSubpackage = customTypesSubpackage;
        this.fluentSubpackage = fluentSubpackage;
        this.requiredParameterClientMethods = requiredParameterClientMethods;
        this.generateSyncAsyncClients = generateSyncAsyncClients;
        this.generateBuilderPerClient = generateBuilderPerClient;
        this.syncMethods = SyncMethodsGeneration.fromValue(syncMethods);
        this.clientLogger = clientLogger;
        this.requiredFieldsAsConstructorArgs = requiredFieldsAsConstructorArgs;
        this.serviceInterfaceAsPublic = serviceInterfaceAsPublic;
        this.artifactId = artifactId;
        this.optionalConstantAsEnum = optionalConstantAsEnum;
        this.dataPlaneClient = dataPlaneClient;
        this.useIterable = useIterable;
        this.serviceVersions = serviceVersions;
        this.requireXMsFlattenedToFlatten = requireXMsFlattenedToFlatten;
        ClientFlattenAnnotationTarget clientFlattenAnnotationTarget2 = this.clientFlattenAnnotationTarget = clientFlattenAnnotationTarget == null || clientFlattenAnnotationTarget.isEmpty() ? ClientFlattenAnnotationTarget.TYPE : ClientFlattenAnnotationTarget.valueOf(clientFlattenAnnotationTarget.toUpperCase(Locale.ROOT));
        if (credentialType != null) {
            splits = credentialType.split(",");
            this.credentialTypes = Arrays.stream(splits).map(String::trim).map(CredentialType::fromValue).collect(Collectors.toSet());
        }
        if (credentialScopes != null) {
            splits = credentialScopes.split(",");
            this.credentialScopes = Arrays.stream(splits).map(String::trim).map(split -> {
                if (!((String)split).startsWith("\"")) {
                    split = "\"" + (String)split + "\"";
                }
                return split;
            }).collect(Collectors.toSet());
        }
        this.customizationJarPath = customizationJarPath;
        this.customizationClass = customizationClass;
        this.keyCredentialHeaderName = keyCredentialHeaderName;
        this.clientBuilderDisabled = clientBuilderDisabled;
        this.skipFormatting = skipFormatting;
        if (pollingConfig != null && !pollingConfig.containsKey("default")) {
            pollingConfig.put("default", new PollingDetails());
        }
        this.pollingConfig = pollingConfig;
        this.generateSamples = generateSamples;
        this.generateTests = generateTests;
        this.generateSendRequestMethod = generateSendRequestMethod;
        this.generateModels = generateModels;
        this.passDiscriminatorToChildDeserialization = passDiscriminatorToChildDeserialization;
        this.annotateGettersAndSettersForSerialization = annotateGettersAndSettersForSerialization;
        this.defaultHttpExceptionType = defaultHttpExceptionType;
        this.useDefaultHttpStatusCodeToExceptionTypeMapping = useDefaultHttpStatusCodeToExceptionTypeMapping;
        this.httpStatusCodeToExceptionTypeMapping = httpStatusCodeToExceptionTypeMapping;
        this.handlePartialUpdate = handlePartialUpdate;
        this.genericResponseTypes = genericResponseTypes;
        this.streamStyleSerialization = streamStyleSerialization;
        this.syncStackEnabled = isSyncStackEnabled;
        this.outputModelImmutable = outputModelImmutable;
        this.isInputStreamForBinary = streamResponseInputStream;
        this.noCustomHeaders = noCustomHeaders;
        this.includeReadOnlyInConstructorArgs = includeReadOnlyInConstructorArgs;
        this.urlAsString = urlAsString;
        this.disableRequiredJsonAnnotation = disableRequiredPropertyAnnotation;
        this.pageSizeEnabled = pageSizeEnabled;
        this.useKeyCredential = useKeyCredential;
        this.nullByteArrayMapsToEmptyArray = nullByteArrayMapsToEmptyArray;
        this.generateGraalVmConfig = generateGraalVmConfig;
        this.branded = branded;
    }

    public boolean isBranded() {
        return this.branded;
    }

    public String getKeyCredentialHeaderName() {
        return this.keyCredentialHeaderName;
    }

    public Set<CredentialType> getCredentialTypes() {
        return this.credentialTypes;
    }

    public Set<String> getCredentialScopes() {
        return this.credentialScopes;
    }

    public final boolean isAzure() {
        return this.azure;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public boolean isNoCustomHeaders() {
        return this.noCustomHeaders;
    }

    public boolean urlAsString() {
        return this.urlAsString;
    }

    public boolean isDisableRequiredJsonAnnotation() {
        return this.disableRequiredJsonAnnotation;
    }

    public final boolean isFluent() {
        return this.fluent != Fluent.NONE;
    }

    public final boolean isFluentLite() {
        return this.fluent == Fluent.LITE;
    }

    public final boolean isFluentPremium() {
        return this.fluent == Fluent.PREMIUM;
    }

    public final boolean isAzureOrFluent() {
        return this.isAzure() || this.isFluent();
    }

    public ClientFlattenAnnotationTarget getClientFlattenAnnotationTarget() {
        return this.clientFlattenAnnotationTarget;
    }

    public ModelerSettings getModelerSettings() {
        return this.modelerSettings;
    }

    public AutorestSettings getAutorestSettings() {
        return this.autorestSettings;
    }

    public Map<String, Object> getSimpleJavaSettings() {
        return SIMPLE_JAVA_SETTINGS;
    }

    public boolean isSdkIntegration() {
        return this.sdkIntegration;
    }

    public final boolean isRegeneratePom() {
        return this.regeneratePom;
    }

    public final String getFileHeaderText() {
        return this.fileHeaderText;
    }

    public final int getMaximumJavadocCommentWidth() {
        return this.maximumJavadocCommentWidth;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getPackage() {
        return this.packageName;
    }

    public final String getPackage(String ... packageSuffixes) {
        StringBuilder packageBuilder = new StringBuilder(this.packageName);
        if (packageSuffixes != null) {
            for (String packageSuffix : packageSuffixes) {
                if (packageSuffix == null || packageSuffix.isEmpty()) continue;
                boolean startsWithPeriod = packageSuffix.startsWith(".");
                boolean endsWithPeriod = packageSuffix.endsWith(".");
                String cleansedPackageSuffix = startsWithPeriod && endsWithPeriod ? packageSuffix.substring(1, packageSuffix.length() - 1) : (startsWithPeriod ? packageSuffix.substring(1) : (endsWithPeriod ? packageSuffix.substring(0, packageSuffix.length() - 1) : packageSuffix));
                packageBuilder.append(".").append(cleansedPackageSuffix);
            }
        }
        return packageBuilder.toString();
    }

    public final boolean isGenerateXmlSerialization() {
        return this.shouldGenerateXmlSerialization;
    }

    public final boolean isNonNullAnnotations() {
        return this.nonNullAnnotations;
    }

    public final boolean isClientSideValidations() {
        return this.clientSideValidations;
    }

    public final String getClientTypePrefix() {
        return this.clientTypePrefix;
    }

    public final boolean isGenerateClientInterfaces() {
        return this.generateClientInterfaces;
    }

    public final boolean isGenerateClientAsImpl() {
        return this.generateClientAsImpl;
    }

    public final String getImplementationSubpackage() {
        return this.implementationSubpackage;
    }

    public final String getModelsSubpackage() {
        return this.modelsSubpackage;
    }

    public final String getFluentSubpackage() {
        return this.fluentSubpackage;
    }

    public final String getFluentModelsSubpackage() {
        if (this.modelsSubpackage.contains(".")) {
            return this.fluentSubpackage + "." + this.modelsSubpackage.substring(this.modelsSubpackage.lastIndexOf(".") + 1);
        }
        return this.fluentSubpackage + "." + this.modelsSubpackage;
    }

    public final boolean isRequiredParameterClientMethods() {
        return this.requiredParameterClientMethods;
    }

    public final boolean isGenerateSyncAsyncClients() {
        return this.generateSyncAsyncClients;
    }

    public final boolean isSyncClientWrapAsyncClient() {
        return !this.syncStackEnabled;
    }

    public final SyncMethodsGeneration getSyncMethods() {
        return this.syncMethods;
    }

    public final boolean isGenerateAsyncMethods() {
        SyncMethodsGeneration syncMethodsGeneration = this.getSyncMethods();
        return syncMethodsGeneration == SyncMethodsGeneration.ALL || syncMethodsGeneration == SyncMethodsGeneration.ESSENTIAL;
    }

    public final boolean isGenerateSyncMethods() {
        SyncMethodsGeneration syncMethodsGeneration = this.getSyncMethods();
        return syncMethodsGeneration == SyncMethodsGeneration.ALL || syncMethodsGeneration == SyncMethodsGeneration.SYNC_ONLY;
    }

    public boolean isRequiredFieldsAsConstructorArgs() {
        return this.requiredFieldsAsConstructorArgs;
    }

    public boolean isServiceInterfaceAsPublic() {
        return this.serviceInterfaceAsPublic;
    }

    public List<String> getCustomTypes() {
        return this.customTypes;
    }

    public boolean isCustomType(String typeName) {
        return this.customTypes.contains(typeName);
    }

    public final String getCustomTypesSubpackage() {
        return this.customTypesSubpackage;
    }

    public final boolean isUseClientLogger() {
        return this.clientLogger;
    }

    public final String getCustomizationJarPath() {
        return this.customizationJarPath;
    }

    public final String getCustomizationClass() {
        return this.customizationClass;
    }

    public boolean isSkipFormatting() {
        return this.skipFormatting;
    }

    public boolean isOptionalConstantAsEnum() {
        return this.optionalConstantAsEnum;
    }

    public boolean isDataPlaneClient() {
        return this.dataPlaneClient;
    }

    public boolean isUseIterable() {
        return this.useIterable;
    }

    public List<String> getServiceVersions() {
        return this.serviceVersions;
    }

    public boolean requireXMsFlattenedToFlatten() {
        return this.requireXMsFlattenedToFlatten;
    }

    public boolean isGenerateSamples() {
        return this.generateSamples;
    }

    public boolean isGenerateTests() {
        return this.generateTests;
    }

    public boolean isGenerateSendRequestMethod() {
        return this.generateSendRequestMethod;
    }

    public boolean isGenerateModels() {
        return this.generateModels;
    }

    public boolean isSyncStackEnabled() {
        return this.syncStackEnabled;
    }

    public boolean clientBuilderDisabled() {
        return this.clientBuilderDisabled;
    }

    public boolean isOutputModelImmutable() {
        return this.outputModelImmutable;
    }

    public boolean isPageSizeEnabled() {
        return this.pageSizeEnabled;
    }

    public boolean isGenerateGraalVmConfig() {
        return this.generateGraalVmConfig;
    }

    public PollingDetails getPollingConfig(String operation) {
        if (this.pollingConfig == null) {
            return null;
        }
        for (String key : this.pollingConfig.keySet()) {
            if (!key.equalsIgnoreCase(operation)) continue;
            return this.pollingConfig.get(key);
        }
        return this.pollingConfig.get("default");
    }

    public boolean isDiscriminatorPassedToChildDeserialization() {
        return this.passDiscriminatorToChildDeserialization;
    }

    public boolean isGettersAndSettersAnnotatedForSerialization() {
        return this.annotateGettersAndSettersForSerialization;
    }

    public String getDefaultHttpExceptionType() {
        return this.defaultHttpExceptionType;
    }

    public boolean isUseDefaultHttpStatusCodeToExceptionTypeMapping() {
        return this.useDefaultHttpStatusCodeToExceptionTypeMapping;
    }

    public Map<Integer, String> getHttpStatusCodeToExceptionTypeMapping() {
        return this.httpStatusCodeToExceptionTypeMapping == null ? null : Collections.unmodifiableMap(this.httpStatusCodeToExceptionTypeMapping);
    }

    public boolean isGenerateBuilderPerClient() {
        return this.generateBuilderPerClient;
    }

    public boolean isHandlePartialUpdate() {
        return this.handlePartialUpdate;
    }

    public boolean isGenericResponseTypes() {
        return this.genericResponseTypes;
    }

    public boolean isStreamStyleSerialization() {
        return this.streamStyleSerialization;
    }

    public boolean isInputStreamForBinary() {
        return this.isInputStreamForBinary;
    }

    public boolean isIncludeReadOnlyInConstructorArgs() {
        return this.includeReadOnlyInConstructorArgs;
    }

    public boolean isUseKeyCredential() {
        return this.useKeyCredential;
    }

    public boolean isNullByteArrayMapsToEmptyArray() {
        return this.nullByteArrayMapsToEmptyArray;
    }

    private static void loadStringSetting(String settingName, Consumer<String> action) {
        String settingValue = host.getStringValue(settingName);
        if (settingValue != null) {
            logger.debug("Option, string, {} : {}", (Object)settingName, (Object)settingValue);
            action.accept(settingValue);
        }
    }

    private static String getStringValue(NewPlugin host, String settingName) {
        String value = host.getStringValue(settingName);
        if (value != null) {
            logger.debug("Option, string, {} : {}", (Object)settingName, (Object)value);
            SIMPLE_JAVA_SETTINGS.put(settingName, value);
        }
        return value;
    }

    private static String getStringValue(NewPlugin host, String settingName, String defaultValue) {
        String ret = host.getStringValue(settingName);
        if (ret == null) {
            return defaultValue;
        }
        logger.debug("Option, string, {} : {}", (Object)settingName, (Object)ret);
        SIMPLE_JAVA_SETTINGS.put(settingName, ret);
        return ret;
    }

    private static boolean getBooleanValue(NewPlugin host, String settingName, boolean defaultValue) {
        Boolean ret = host.getBooleanValue(settingName);
        if (ret == null) {
            return defaultValue;
        }
        logger.debug("Option, boolean, {} : {}", (Object)settingName, (Object)ret);
        SIMPLE_JAVA_SETTINGS.put(settingName, ret);
        return ret;
    }

    private static void loadStringOrArraySettingAsArray(String settingName, Consumer<List<String>> action) {
        ArrayList<String> settingValues = new ArrayList<String>();
        Object settingValue = host.getValue((Type)((Object)Object.class), settingName);
        if (settingValue instanceof String) {
            logger.debug("Option, string, {} : {}", (Object)settingName, settingValue);
            settingValues.add(settingValue.toString());
        } else if (settingValue instanceof List) {
            List settingValueList = (List)settingValue;
            logger.debug("Option, array, {} : {}", (Object)settingName, (Object)settingValueList);
            settingValues.addAll(settingValueList);
        }
        if (!settingValues.isEmpty()) {
            action.accept(settingValues);
        }
    }

    static {
        SIMPLE_JAVA_SETTINGS = new HashMap<String, Object>();
        DEFAULT_CODE_GENERATION_HEADER = String.join((CharSequence)"\r\n", "Code generated by Microsoft (R) AutoRest Code Generator %s", "Changes may cause incorrect behavior and will be lost if the code is regenerated.");
        DEFAULT_CODE_GENERATION_HEADER_WITHOUT_VERSION = String.join((CharSequence)"\r\n", "Code generated by Microsoft (R) AutoRest Code Generator.", "Changes may cause incorrect behavior and will be lost if the code is regenerated.");
        MICROSOFT_APACHE_LICENSE_HEADER = String.join((CharSequence)"\r\n", "Copyright (c) Microsoft and contributors.  All rights reserved.\r\n", "Licensed under the Apache License, Version 2.0 (the \"License\");", "you may not use this file except in compliance with the License.", "You may obtain a copy of the License at", "  https://www.apache.org/licenses/LICENSE-2.0\r\n", "Unless required by applicable law or agreed to in writing, software", "distributed under the License is distributed on an \"AS IS\" BASIS,", "WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n", "See the License for the specific language governing permissions and", "limitations under the License.", "");
        MICROSOFT_MIT_LICENSE_HEADER = String.join((CharSequence)"\r\n", "Copyright (c) Microsoft Corporation. All rights reserved.", "Licensed under the MIT License. See License.txt in the project root for license information.", "");
        MICROSOFT_MIT_SMALL_LICENSE_HEADER = String.join((CharSequence)"\r\n", "Copyright (c) Microsoft Corporation. All rights reserved.", "Licensed under the MIT License.", "");
    }

    public static class ModelerSettings {
        private final Map<String, Object> settings;

        public ModelerSettings(Map<String, Object> settings) {
            this.settings = settings == null ? Collections.emptyMap() : settings;
        }

        public Map<String, Object> getSettings() {
            return this.settings;
        }

        public boolean isFlattenModel() {
            return this.settings.containsKey("flatten-models") && (Boolean)this.settings.get("flatten-models") != false;
        }
    }

    public static enum Fluent {
        NONE,
        LITE,
        PREMIUM;

    }

    public static enum SyncMethodsGeneration {
        ALL,
        ESSENTIAL,
        SYNC_ONLY,
        NONE;


        public static SyncMethodsGeneration fromValue(String value) {
            if (value == null) {
                return null;
            }
            if (value.equals("all")) {
                return ALL;
            }
            if (value.equals("essential")) {
                return ESSENTIAL;
            }
            if (value.equals("none")) {
                return NONE;
            }
            if (value.equals("sync-only")) {
                return SYNC_ONLY;
            }
            return null;
        }
    }

    public static enum ClientFlattenAnnotationTarget {
        TYPE,
        FIELD,
        NONE,
        DISABLED;

    }

    public static class PollingDetails {
        @JsonProperty(value="strategy")
        private String strategy;
        @JsonProperty(value="intermediate-type")
        private String intermediateType;
        @JsonProperty(value="final-type")
        private String finalType;
        @JsonProperty(value="poll-interval")
        private String pollInterval;
        @JsonProperty(value="sync-strategy")
        private String syncStrategy;
        public static final String DEFAULT_POLLING_STRATEGY_FORMAT = String.join((CharSequence)"\n", "new %s<>(new PollingStrategyOptions({httpPipeline})", "    .setEndpoint({endpoint})", "    .setContext({context})", "    .setServiceVersion({serviceVersion}))");
        private static final String DEFAULT_POLLING_CODE = String.format(DEFAULT_POLLING_STRATEGY_FORMAT, "DefaultPollingStrategy");
        private static final String DEFAULT_SYNC_POLLING_CODE = String.format(DEFAULT_POLLING_STRATEGY_FORMAT, "SyncDefaultPollingStrategy");

        public String getStrategy() {
            if (this.strategy == null || "default".equalsIgnoreCase(this.strategy)) {
                return DEFAULT_POLLING_CODE;
            }
            return this.strategy;
        }

        public String getSyncStrategy() {
            if (this.syncStrategy == null || "default".equalsIgnoreCase(this.syncStrategy)) {
                return DEFAULT_SYNC_POLLING_CODE;
            }
            return this.syncStrategy;
        }

        public String getIntermediateType() {
            return this.intermediateType;
        }

        public String getFinalType() {
            return this.finalType;
        }

        public int getPollIntervalInSeconds() {
            return this.pollInterval != null ? Integer.parseInt(this.pollInterval) : 1;
        }
    }

    public static enum CredentialType {
        TOKEN_CREDENTIAL,
        AZURE_KEY_CREDENTIAL,
        NONE;


        public static CredentialType fromValue(String value) {
            if (value == null) {
                return null;
            }
            if (value.equals("tokencredential")) {
                return TOKEN_CREDENTIAL;
            }
            if (value.equals("azurekeycredential")) {
                return AZURE_KEY_CREDENTIAL;
            }
            if (value.equals("none")) {
                return NONE;
            }
            return NONE;
        }
    }
}

