/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.plugin;

import com.azure.autorest.extension.base.jsonrpc.Connection;
import com.azure.autorest.extension.base.model.Message;
import com.azure.autorest.extension.base.model.MessageChannel;
import com.azure.autorest.extension.base.model.codemodel.AnnotatedPropertyUtils;
import com.azure.autorest.extension.base.model.codemodel.CodeModelCustomConstructor;
import com.azure.autorest.extension.base.plugin.JavaSettings;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.inspector.TrustedTagInspector;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.representer.Representer;

public abstract class NewPlugin {
    protected final ObjectMapper jsonMapper;
    protected final Yaml yamlMapper;
    protected Connection connection;
    private String plugin;
    private String sessionId;

    public String readFile(String fileName) {
        return (String)this.connection.request(this.jsonMapper.constructType(String.class), "ReadFile", this.sessionId, fileName);
    }

    public <T> T getValue(Type type, String key) {
        return this.connection.request(this.jsonMapper.constructType(type), "GetValue", this.sessionId, key);
    }

    public String getStringValue(String key) {
        return (String)this.getValue((Type)((Object)String.class), key);
    }

    public String getStringValue(String key, String defaultValue) {
        String ret = this.getStringValue(key);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    public String getStringValue(String[] keys, String defaultValue) {
        String key;
        String ret = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (ret = this.getStringValue(key = stringArray[i])) == null; ++i) {
        }
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    public Boolean getBooleanValue(String key) {
        return (Boolean)this.getValue((Type)((Object)Boolean.class), key);
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        Boolean ret = this.getBooleanValue(key);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    public List<String> listInputs() {
        return (List)this.connection.request((JavaType)this.jsonMapper.getTypeFactory().constructCollectionLikeType(List.class, String.class), "ListInputs", this.sessionId, null);
    }

    public List<String> listInputs(String artifactType) {
        return (List)this.connection.request((JavaType)this.jsonMapper.getTypeFactory().constructCollectionLikeType(List.class, String.class), "ListInputs", this.sessionId, artifactType);
    }

    public void message(Message message) {
        this.connection.notify("Message", this.sessionId, message);
    }

    public void message(MessageChannel channel, String text, Throwable error, List<String> keys) {
        Message message = new Message();
        message.setChannel(channel);
        message.setKey(keys);
        message.setSource(Collections.emptyList());
        if (error != null) {
            text = (String)text + "\n" + this.formatThrowableMessage(error);
        }
        message.setText((String)text);
        this.message(message);
    }

    public void writeFile(String fileName, String content, List<Object> sourceMap) {
        this.connection.notify("WriteFile", this.sessionId, fileName, content, sourceMap);
    }

    public void writeFile(final String fileName, final String content, final List<Object> sourceMap, final String artifactType) {
        Message message = new Message();
        message.setChannel(MessageChannel.FILE);
        message.setDetails(new HashMap<String, Object>(){
            {
                this.put("content", content);
                this.put("type", artifactType);
                this.put("uri", fileName);
                this.put("sourceMap", sourceMap);
            }
        });
        message.setText(content);
        message.setKey(Arrays.asList(artifactType, fileName));
        this.connection.notify("Message", this.sessionId, message);
    }

    public void protectFiles(String path) {
        List<String> items = this.listInputs(path);
        if (items != null && items.size() > 0) {
            for (String item : items) {
                String content = this.readFile(item);
                this.writeFile(item, content, null, "preserved-files");
            }
        }
        String contentSingle = this.readFile(path);
        this.writeFile(path, contentSingle, null, "preserved-files");
    }

    public String getConfigurationFile(String fileName) {
        Iterator it;
        Map configurations = (Map)this.getValue(new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{String.class, String.class};
            }

            @Override
            public Type getRawType() {
                return Map.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        }, "configurationFiles");
        if (configurations != null && (it = configurations.keySet().iterator()).hasNext()) {
            String first = (String)it.next();
            first = first.substring(0, first.lastIndexOf(47));
            for (String configFile : configurations.keySet()) {
                if (!String.format("%s/%s", first, fileName).equals(configFile)) continue;
                return (String)configurations.get(configFile);
            }
        }
        return "";
    }

    public void updateConfigurationFile(String filename, String content) {
        Message message = new Message();
        message.setChannel(MessageChannel.CONFIGURATION);
        message.setKey(Arrays.asList(filename));
        message.setText(content);
        this.connection.notify("Message", this.sessionId, message);
    }

    public NewPlugin(Connection connection, String plugin, String sessionId) {
        this.connection = connection;
        this.plugin = plugin;
        this.sessionId = sessionId;
        this.jsonMapper = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.jsonMapper.setVisibility(this.jsonMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
        Representer representer = new Representer(new DumperOptions());
        representer.setPropertyUtils((PropertyUtils)new AnnotatedPropertyUtils());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x3200000);
        loaderOptions.setMaxAliasesForCollections(Integer.MAX_VALUE);
        loaderOptions.setNestingDepthLimit(Integer.MAX_VALUE);
        loaderOptions.setTagInspector((TagInspector)new TrustedTagInspector());
        CodeModelCustomConstructor constructor = new CodeModelCustomConstructor(loaderOptions);
        this.yamlMapper = new Yaml((BaseConstructor)constructor, representer, new DumperOptions(), loaderOptions);
    }

    public boolean process() {
        try {
            JavaSettings.setHost(this);
            return this.processInternal();
        }
        catch (Throwable t) {
            this.message(MessageChannel.FATAL, "Unhandled error: " + t.getMessage(), t, Arrays.asList(this.getClass().getSimpleName()));
            return false;
        }
    }

    public abstract boolean processInternal();

    private String formatThrowableMessage(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

