/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.service;

import com.bea.common.security.SecurityLogger;
import weblogic.security.service.ApplicationResource;
import weblogic.security.service.InvalidParameterException;
import weblogic.security.service.LegacyEnforceStrictURLPatternManager;
import weblogic.security.service.LegacyWebAppFilesCaseInsensitiveManager;
import weblogic.security.service.ResourceBase;
import weblogic.security.spi.Resource;

public final class URLResource
extends ResourceBase {
    private static final String[] KEYS = new String[]{"application", "contextPath", "uri", "httpMethod", "transportType"};
    private static final int REPEATING_FIELD_INDEX = 3;
    private static final int REPEATING_FIELD_TERMINATING_INDEX = 2;
    private static final Resource TOP = new URLResource(null, 0, null, null, false);
    private String suffix = null;
    private String httpMethod = null;
    private boolean URIUnchanged = true;
    private static boolean doMappingToLowerCase = false;
    private static boolean enforceStrictURLPattern = true;

    public URLResource(String application, String contextPathArg, String uriArg, String httpMethod, String transportType) {
        this(application, contextPathArg, uriArg, httpMethod, transportType, LegacyWebAppFilesCaseInsensitiveManager.getWebAppFilesCaseInsensitive());
    }

    public URLResource(String application, String contextPathArg, String uriArg, String httpMethod, String transportType, boolean areWebAppFilesCaseInsensitive) {
        if (application != null && application.length() == 0) {
            throw new InvalidParameterException(SecurityLogger.getEmptyResourceKeyString((String)"URL", (String)KEYS[0]));
        }
        String uri = uriArg;
        String contextPath = contextPathArg;
        doMappingToLowerCase = areWebAppFilesCaseInsensitive;
        enforceStrictURLPattern = LegacyEnforceStrictURLPatternManager.getEnforceStrictURLPattern();
        if (contextPath != null && doMappingToLowerCase) {
            contextPath = contextPath.toLowerCase();
        }
        if (uri != null) {
            int suffixIndex;
            int finalSlash;
            if (doMappingToLowerCase) {
                uri = uri.toLowerCase();
            }
            if ((finalSlash = uri.lastIndexOf("/")) == -1) {
                finalSlash = 1;
            }
            if ((suffixIndex = uri.lastIndexOf(".")) != -1 && suffixIndex > finalSlash) {
                this.suffix = "*" + uri.substring(suffixIndex);
            }
            if (!uri.startsWith("/") && !uri.startsWith("*.")) {
                uri = "/" + uri;
            }
        }
        String[] vals = new String[]{application, contextPath, uri, httpMethod, transportType};
        this.init(vals, 5, 0L, httpMethod, this.suffix, true);
    }

    private URLResource(String[] values, int length, String httpMethod, String suffix, boolean URIUnchanged) {
        this.init(values, length, 0L, httpMethod, suffix, URIUnchanged);
    }

    protected void init(String[] values, int len, long seed, String httpMethod, String suffix, boolean URIUnchanged) {
        this.suffix = suffix;
        this.httpMethod = httpMethod;
        this.URIUnchanged = URIUnchanged;
        super.init(values, len, seed += (URIUnchanged ? 31L : -31L) * (long)((httpMethod == null ? 0 : httpMethod.hashCode() + 1) + (suffix == null ? 0 : suffix.hashCode() + 3)));
    }

    public String getType() {
        return "<url>";
    }

    private Resource makeParentBackwardCompatible() {
        switch (this.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new ApplicationResource(this.values[0], TOP);
            }
            case 3: {
                String uri = this.values[2];
                if (uri.startsWith("*.")) {
                    return this.urlResourceWithNewURI("/*", this.httpMethod, null);
                }
                int finalSlash = uri.lastIndexOf("/");
                if (uri.endsWith("/")) {
                    return this.urlResourceWithNewURI(uri.substring(0, finalSlash) + "/*", this.httpMethod, null);
                }
                if (finalSlash != -1 && (uri.endsWith("/") || uri.endsWith("/*"))) {
                    finalSlash = uri.lastIndexOf("/", finalSlash - 1);
                } else if (this.URIUnchanged && uri != null) {
                    return this.urlResourceWithNewURI(uri + "/*", this.httpMethod, this.suffix, false);
                }
                if (finalSlash == 0) {
                    if (this.suffix != null) {
                        return this.urlResourceWithNewURI(this.suffix, this.httpMethod, null);
                    }
                    return this.urlResourceWithNewURI("/*", this.httpMethod, null);
                }
                if (finalSlash != -1) {
                    String newURI = uri.substring(0, finalSlash) + "/*";
                    return this.urlResourceWithNewURI(newURI, this.httpMethod, this.suffix);
                }
                return new URLResource(this.values, 2, this.httpMethod, this.suffix, false);
            }
        }
        return new URLResource(this.values, this.length - 1, this.httpMethod, this.suffix, this.URIUnchanged);
    }

    protected Resource makeParent() {
        if (!enforceStrictURLPattern) {
            return this.makeParentBackwardCompatible();
        }
        switch (this.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new ApplicationResource(this.values[0], TOP);
            }
            case 3: {
                String uri = this.values[2];
                if (uri.equals("/")) {
                    return new URLResource(this.values, 2, this.httpMethod, this.suffix, false);
                }
                if (uri.startsWith("*.")) {
                    return this.urlResourceWithNewURI("/", this.httpMethod, null);
                }
                if (uri.equals("/*")) {
                    if (this.suffix != null) {
                        return this.urlResourceWithNewURI(this.suffix, this.httpMethod, null);
                    }
                    return this.urlResourceWithNewURI("/", this.httpMethod, null);
                }
                int finalSlash = uri.lastIndexOf("/");
                if (uri.endsWith("/")) {
                    return this.urlResourceWithNewURI(uri.substring(0, finalSlash) + "/*", this.httpMethod, null);
                }
                if (finalSlash != -1 && (uri.endsWith("/") || uri.endsWith("/*"))) {
                    finalSlash = uri.lastIndexOf("/", finalSlash - 1);
                } else if (this.URIUnchanged && uri != null) {
                    return this.urlResourceWithNewURI(uri + "/*", this.httpMethod, this.suffix, false);
                }
                if (finalSlash == 0) {
                    return this.urlResourceWithNewURI("/*", this.httpMethod, this.suffix);
                }
                if (finalSlash != -1) {
                    String newURI = uri.substring(0, finalSlash) + "/*";
                    return this.urlResourceWithNewURI(newURI, this.httpMethod, this.suffix);
                }
                return new URLResource(this.values, 2, this.httpMethod, this.suffix, false);
            }
        }
        return new URLResource(this.values, this.length - 1, this.httpMethod, this.suffix, this.URIUnchanged);
    }

    private URLResource urlResourceWithNewURI(String newURI, String httpMethod, String newSuffix, boolean URIUnchanged) {
        int size = 3;
        if (httpMethod != null) {
            size = 4;
        }
        return new URLResource(new String[]{this.values[0], this.values[1], newURI, httpMethod}, size, httpMethod, newSuffix, URIUnchanged);
    }

    private URLResource urlResourceWithNewURI(String newURI, String httpMethod, String newSuffix) {
        return this.urlResourceWithNewURI(newURI, httpMethod, newSuffix, this.URIUnchanged);
    }

    public String[] getKeys() {
        return KEYS;
    }

    public int getFieldType(String fieldName) {
        if (fieldName.equals("uri")) {
            return 2;
        }
        return 1;
    }

    public int getRepeatingFieldIndex() {
        return 3;
    }

    public int getRepeatingFieldTerminatingIndex() {
        return 2;
    }

    public String getApplicationName() {
        return this.length > 0 ? this.values[0] : null;
    }

    public String getContextPath() {
        return this.length > 1 ? this.values[1] : null;
    }

    public String getURI() {
        return this.length > 2 ? this.values[2] : null;
    }

    public String getHttpMethod() {
        return this.length > 3 ? this.values[3] : null;
    }

    public String getTransportType() {
        return this.length > 4 ? this.values[4] : null;
    }

    public boolean mappingToLowerCase() {
        return doMappingToLowerCase;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        URLResource r = (URLResource)obj;
        return this.URIUnchanged == r.URIUnchanged && (this.httpMethod == null && r.httpMethod == null || this.httpMethod != null && this.httpMethod.equals(r.httpMethod)) && (this.suffix == null && r.suffix == null || this.suffix != null && this.suffix.equals(r.suffix));
    }
}

