/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.management.commo;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;

public class WLMBeanMaker
extends Task {
    private static final Class[] MAIN_SIGNATURE = new Class[]{String[].class};
    private String compiler;
    private String source;
    private String target;
    private String files;
    private String mdfFile;
    private String mdfDir;
    private String mjfJar;
    private String mbeantypesDir;
    private boolean noCompile;
    private Path classpath;
    private boolean createStubs = true;
    private boolean doBeanGen = false;
    private boolean doCheckDescription = false;
    private boolean preserveStubs;
    private boolean internalWLSBuild;
    private String targetNamespace = null;
    private String schemaLocation = null;
    private boolean compileDebug = false;
    private boolean verbose = false;
    private String jvmArgs = null;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setCompiler(String string) {
        this.compiler = string;
    }

    public void setCreateStubs(boolean bl) {
        this.createStubs = bl;
    }

    public void setDoBeanGen(boolean bl) {
        this.doBeanGen = bl;
    }

    public void setDoCheckDescription(boolean bl) {
        this.doCheckDescription = bl;
    }

    public void setPreserveStubs(boolean bl) {
        this.preserveStubs = bl;
    }

    public void setFiles(String string) {
        this.files = string;
    }

    public void setMDFFile(String string) {
        this.mdfFile = string;
    }

    public void setMDFDir(String string) {
        this.mdfDir = string;
    }

    public void setNoCompile(boolean bl) {
        this.noCompile = bl;
    }

    public void setMJFJar(String string) {
        this.mjfJar = string;
    }

    public void setMBeanTypesDir(String string) {
        this.mbeantypesDir = string;
    }

    public void setTargetNameSpace(String string) {
        this.targetNamespace = string;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public void setJvmArgs(String string) {
        this.jvmArgs = string;
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath;
    }

    public void setInternalWLSBuild(boolean bl) {
        this.internalWLSBuild = bl;
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setCompileDebug(boolean bl) {
        this.compileDebug = bl;
    }

    public void execute() throws BuildException {
        Object object;
        GenericClassLoader genericClassLoader;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.verbose) {
            arrayList.add("-verbose");
        }
        if (this.compiler != null) {
            arrayList.add("-compiler");
            arrayList.add(this.compiler);
        }
        if (this.source != null) {
            arrayList.add("-source");
            arrayList.add(this.source);
        }
        if (this.target != null) {
            arrayList.add("-target");
            arrayList.add(this.target);
        }
        if (this.createStubs) {
            arrayList.add("-createStubs");
        }
        if (this.doBeanGen) {
            arrayList.add("-doBeanGen");
        }
        if (this.doCheckDescription) {
            arrayList.add("-doCheckDescription");
        }
        if (this.preserveStubs) {
            arrayList.add("-preserveStubs");
        }
        if (this.files != null) {
            arrayList.add("-files");
            arrayList.add(this.files);
        }
        if (this.mdfFile != null) {
            arrayList.add("-MDF");
            arrayList.add(this.mdfFile);
        }
        if (this.mdfDir != null) {
            arrayList.add("-MDFDIR");
            arrayList.add(this.mdfDir);
        }
        if (this.noCompile) {
            arrayList.add("-noCompile");
        }
        if (this.mjfJar != null) {
            arrayList.add("-MJF");
            arrayList.add(this.mjfJar);
        }
        if (this.mbeantypesDir != null) {
            arrayList.add("-mbeantypesDir");
            arrayList.add(this.mbeantypesDir);
        }
        if (this.compileDebug) {
            arrayList.add("-g");
        }
        if (this.targetNamespace != null) {
            arrayList.add("-targetNameSpace");
            arrayList.add(this.targetNamespace);
        }
        if (this.schemaLocation != null) {
            arrayList.add("-schemaLocation");
            arrayList.add(this.schemaLocation);
        }
        if (this.jvmArgs != null) {
            arrayList.add("-jvmArgs");
            arrayList.add(this.jvmArgs);
        }
        if (this.internalWLSBuild) {
            arrayList.add("-internalWLSBuild");
        }
        if (this.classpath == null) {
            this.createClasspath().setPath(System.getProperty("java.class.path"));
            this.classpath.createPathElement().setLocation(new File(this.files));
            stringArray = new ClasspathClassFinder2(this.files);
            genericClassLoader = new GenericClassLoader((ClassFinder)stringArray, ((Object)((Object)this)).getClass().getClassLoader());
        } else {
            stringArray = this.classpath.toString().trim() + File.pathSeparatorChar + this.files;
            object = new ClasspathClassFinder2((String)stringArray);
            genericClassLoader = GenericClassLoader.getRootClassLoader((ClassFinder)object);
        }
        arrayList.add("-classpath");
        arrayList.add(this.classpath.toString().trim());
        stringArray = this.getArgs(arrayList);
        object = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)genericClassLoader);
            Class<?> clazz = genericClassLoader.loadClass("weblogic.management.commo.WebLogicMBeanMaker");
            Method method = null;
            method = clazz.getMethod("main", MAIN_SIGNATURE);
            Object[] objectArray = new Object[]{stringArray};
            System.out.print("weblogic.management.commo.WebLogicMBeanMaker ");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(stringArray[i]);
                System.out.print(" ");
            }
            System.out.println("");
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException(exception.toString());
        }
        finally {
            Thread.currentThread().setContextClassLoader((ClassLoader)object);
        }
    }

    protected String[] getArgs(List list) {
        ArrayList arrayList = new ArrayList(list);
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

