/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import javax.management.Descriptor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.management.commo.CommoModelMBeanAttributeInfo;
import weblogic.management.commo.CommoModelMBeanInfoSupport;
import weblogic.management.commo.CommoModelMBeanOperationInfo;
import weblogic.management.commo.WebLogicMBeanMaker;
import weblogic.utils.compiler.CodeGenerator;

public class AbstractCodeGenerator
extends CodeGenerator {
    WebLogicMBeanMaker tool = null;
    Node currentObject = null;
    Node currentParam = null;
    Node currentException = null;
    Node currentTag = null;
    int count;
    private static Descriptor defaultDescriptor = null;
    private static Descriptor defaultAttrDescriptor = null;
    private static Descriptor defaultOperDescriptor = null;

    AbstractCodeGenerator(WebLogicMBeanMaker webLogicMBeanMaker) {
        this.tool = webLogicMBeanMaker;
    }

    Node getCurrentObject() {
        if (this.currentObject == null) {
            this.currentObject = this.tool.root;
        }
        return this.currentObject;
    }

    public String count() {
        String string = "" + this.count;
        return string;
    }

    public String objectName() {
        return this.tool.getName(this.getCurrentObject());
    }

    public String className() {
        return this.tool.attrVal(this.getCurrentObject(), "ClassName");
    }

    public String description() throws Exception {
        return this.tool.getDescription(this.getCurrentObject());
    }

    public String attributeType() {
        return this.tool.attrVal(this.getCurrentObject(), "Type");
    }

    public String attributeTypeSimple() {
        String string = this.attributeType();
        return string.substring(0, string.indexOf("["));
    }

    public String attributeTypeType() {
        if (this.attributeType().equals("javax.management.ObjectName")) {
            String string = this.tool.attrVal(this.getCurrentObject(), "InterfaceType");
            return string + "MBean.class";
        }
        if (this.attributeType().equals("javax.management.ObjectName[]")) {
            String string = this.tool.attrVal(this.getCurrentObject(), "InterfaceType");
            return string + "MBean[].class";
        }
        return this.getType(this.attributeType());
    }

    public String attributeTypeTypeSimple() {
        return this.getType(this.attributeTypeSimple());
    }

    String getType(String string) {
        String string2 = string.trim();
        if (string2.trim().equals("int")) {
            return "Integer.TYPE";
        }
        if (string2.trim().equals("boolean")) {
            return "Boolean.TYPE";
        }
        if (string2.trim().equals("long")) {
            return "Long.TYPE";
        }
        if (string2.trim().equals("float")) {
            return "Float.TYPE";
        }
        if (string2.trim().equals("double")) {
            return "Double.TYPE";
        }
        if (string2.trim().equals("character")) {
            return "Character.TYPE";
        }
        if (string2.trim().equals("byte")) {
            return "Byte.TYPE";
        }
        if (string2.trim().equals("short")) {
            return "Short.TYPE";
        }
        return string2 + ".class";
    }

    public String attributeGetterName() {
        return this.tool.attrVal(this.getCurrentObject(), "GetMethod");
    }

    public String attributeSetterName() {
        return this.tool.attrVal(this.getCurrentObject(), "SetMethod");
    }

    public String attributeValidatorName() {
        return this.tool.attrVal(this.getCurrentObject(), "Validator");
    }

    public String attributeArrayIndexGetterName() {
        return "get" + this.objectName() + "ElementAt";
    }

    public String attributeArrayIndexSetterName() {
        return "set" + this.objectName() + "ElementAt";
    }

    public String operationReturnType() {
        return this.tool.attrVal(this.getCurrentObject(), "ReturnType");
    }

    public String operationParams() {
        String string = "";
        NodeList nodeList = this.getCurrentObject().getChildNodes();
        boolean bl = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("MBeanOperationArg")) continue;
            this.currentParam = node;
            if (!bl) {
                string = string + ", ";
            }
            bl = false;
            string = string + this.paramType() + " " + this.paramName();
        }
        return string;
    }

    public String paramName() {
        return this.tool.attrVal(this.currentParam, "Name");
    }

    public String paramType() {
        return this.tool.attrVal(this.currentParam, "Type");
    }

    public static boolean isSubtype(Class clazz, Class clazz2) {
        if (clazz.equals(clazz2)) {
            return true;
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 != null && AbstractCodeGenerator.isSubtype(clazz3, clazz2)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!AbstractCodeGenerator.isSubtype(classArray[i], clazz2)) continue;
            return true;
        }
        return false;
    }

    private Descriptor getDefaultDescriptor() {
        try {
            if (defaultDescriptor == null) {
                defaultDescriptor = CommoModelMBeanInfoSupport.makeMBeanDescriptorSupport();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return defaultDescriptor;
    }

    String getDValue(String string) {
        String string2 = this.tool.attrVal(this.tool.root, string);
        if (string2 == null) {
            string2 = (String)this.getDefaultDescriptor().getFieldValue(string);
        }
        return string2;
    }

    private Descriptor getDefaultAttrDescriptor() {
        try {
            if (defaultAttrDescriptor == null) {
                defaultAttrDescriptor = CommoModelMBeanAttributeInfo.makeAttributeDescriptorSupport();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return defaultAttrDescriptor;
    }

    String getAValue(String string) {
        String string2 = this.tool.attrVal(this.currentObject, string);
        if (string2 == null) {
            string2 = (String)this.getDefaultAttrDescriptor().getFieldValue(string);
        }
        return string2;
    }

    private Descriptor getDefaultOperDescriptor() {
        try {
            if (defaultOperDescriptor == null) {
                defaultOperDescriptor = CommoModelMBeanOperationInfo.makeOperationDescriptorSupport();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return defaultOperDescriptor;
    }

    String getOValue(String string) {
        String string2 = this.tool.attrVal(this.currentObject, string);
        if (string2 == null) {
            string2 = (String)this.getDefaultOperDescriptor().getFieldValue(string);
        }
        return string2;
    }

    boolean getAValueBool(String string) {
        String string2 = this.tool.attrVal(this.currentObject, string);
        boolean bl = false;
        if (string2 == null) {
            string2 = (String)this.getDefaultAttrDescriptor().getFieldValue(string);
        }
        try {
            bl = Boolean.valueOf(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public String attributeIsReadable() {
        return this.getAValue("Readable");
    }

    public String attributeIsWriteable() {
        return this.getAValue("Writeable");
    }

    public String attributeIsIs() {
        return this.getAValue("IsIs");
    }

    public String attributeMin() {
        return this.getAValue("Min");
    }

    public String attributeMax() {
        return this.getAValue("Max");
    }

    public String attributeDefault() {
        return this.getAValue("Default");
    }

    public String attributeDefaultDefault() {
        return this.getAValue("DefaultString");
    }

    public String attributeLegalValues() {
        return this.getAValue("LegalValues");
    }

    public String notificationTypes() {
        return this.getAValue("NotificationTypes");
    }

    public String attributeValidator() {
        return this.getAValue("Validator");
    }

    public String attributeDeprecated() {
        return this.getAValue("Deprecated");
    }

    public String attributeObsolete() {
        return this.getAValue("Obsolete");
    }

    public String attributeIsPreviouslyPersisted() {
        return this.getAValue("PreviouslyPersisted");
    }

    public String operationImpact() {
        String string = this.getOValue("Impact");
        if (string == null) {
            return null;
        }
        int n = Integer.parseInt(string);
        switch (n) {
            case 0: {
                return "info";
            }
            case 1: {
                return "action";
            }
            case 2: {
                return "action_info";
            }
        }
        return "unknown";
    }

    class Output
    extends CodeGenerator.Output {
        public Output(String string, String string2, String string3) {
            super(string, string2, string3);
        }
    }
}

