/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;
import weblogic.management.commo.DescriptorSupportBase;

public class DescriptorSupport
implements Descriptor {
    static final long serialVersionUID = 8071560848919417985L;
    public String currClass = null;
    HashMap descriptor = null;
    private ArrayList descriptor2 = null;
    private Descriptor delegate = null;
    private int fieldCount = 0;
    private int voidCount = 0;
    static final int defaultSize = 2;
    static final ArrayList emptyList = new ArrayList(0);
    static final VoidValue voidValue = new VoidValue();

    public DescriptorSupport() {
    }

    public DescriptorSupport(int n) throws MBeanException, RuntimeOperationsException {
        if (n <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor field limit is invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor2 = new ArrayList(n);
    }

    public DescriptorSupport(DescriptorSupport descriptorSupport) {
        this.delegate = descriptorSupport;
        if (this.delegate != null) {
            this.fieldCount = ((DescriptorSupport)this.delegate).getFieldCount();
            this.voidCount = ((DescriptorSupport)this.delegate).getVoidCount();
        }
        while (this.delegate != null && this.delegate instanceof DescriptorSupport && ((DescriptorSupport)this.delegate).getFieldCountLocal() == 0) {
            this.delegate = ((DescriptorSupport)this.delegate).delegate;
        }
    }

    protected int getFieldCount() {
        this.getDescriptor();
        return this.fieldCount;
    }

    protected int getFieldCountLocal() {
        int n = 0;
        Iterator iterator = this.getDescriptor().iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.value instanceof VoidValue) continue;
            ++n;
        }
        return n;
    }

    protected int getVoidCount() {
        this.getDescriptor();
        return this.voidCount;
    }

    public DescriptorSupport(String string) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor is null or invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor2 = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<> \t\n\r\f");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase("FIELD")) {
                bl = true;
                continue;
            }
            if (string4.equalsIgnoreCase("/FIELD")) {
                if (string2 != null && string3 != null) {
                    this.setField(string2.toLowerCase(), string3);
                }
                string2 = null;
                string3 = null;
                bl = false;
                continue;
            }
            if (string4.equalsIgnoreCase("DESCRIPTOR")) {
                bl2 = true;
                continue;
            }
            if (string4.equalsIgnoreCase("/DESCRIPTOR")) {
                bl2 = false;
                string2 = null;
                string3 = null;
                bl = false;
                continue;
            }
            if (!bl || !bl2) continue;
            int n = string4.indexOf("=");
            if (n > 0) {
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                if (string5.equalsIgnoreCase("NAME")) {
                    string2 = new String(string6);
                    continue;
                }
                if (string5.equalsIgnoreCase("VALUE")) {
                    string3 = new String(string6);
                    continue;
                }
                throw new XMLParseException("expected a field value, received '" + string4 + "'");
            }
            throw new XMLParseException("expected keyword=value, received '" + string4 + "'");
        }
    }

    public DescriptorSupport(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        this.descriptor2 = new ArrayList(stringArray.length);
        if (stringArray == null && objectArray == null || stringArray.length == 0 && objectArray.length == 0) {
            this.descriptor2 = new ArrayList();
            return;
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames or FieldValues are null or invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor2 = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.setField(stringArray[i], objectArray[i]);
        }
    }

    public DescriptorSupport(String[] stringArray) {
        this.descriptor2 = new ArrayList(stringArray.length);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) continue;
            int n = stringArray[i].indexOf("=");
            if (n <= 0) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no equals sign"), "Exception occured trying to construct a descriptor");
            }
            String string = stringArray[i].substring(0, n);
            String string2 = null;
            if (n < stringArray[i].length()) {
                string2 = stringArray[i].substring(n + 1);
            }
            if (string == null || string.equals("")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no equals sign"), "Exception occured trying to construct a descriptor");
            }
            this.setField(string, string2);
        }
    }

    private ArrayList getDescriptor() {
        return this.getDescriptor(false);
    }

    private ArrayList getDescriptor(boolean bl) {
        if (this.descriptor2 == null) {
            if (!bl && this.descriptor != null && this.descriptor.size() == 0) {
                return emptyList;
            }
            this.descriptor2 = new ArrayList(2);
            if (this.descriptor != null) {
                Set set = this.descriptor.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.descriptor2.add(new Pair(entry.getKey(), entry.getValue()));
                    ++this.fieldCount;
                }
                this.descriptor = null;
            }
        }
        return this.descriptor2;
    }

    public Object getFieldValue(String string) throws RuntimeOperationsException {
        Object object = this.getFieldValueX(string);
        if (object == null && string.equalsIgnoreCase("displayname")) {
            return this.getFieldValueX("Name");
        }
        return object;
    }

    private Object getFieldValueX(String string) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname requested is null"), "Exception occured trying to get a field from a descriptor");
        }
        Pair pair = this.findEntry(this.getDescriptor(), string.toLowerCase());
        if (pair != null) {
            if (pair.value instanceof VoidValue) {
                return null;
            }
            return pair.value;
        }
        if (this.delegate != null) {
            if (this.delegate instanceof DescriptorSupportBase) {
                return ((DescriptorSupportBase)this.delegate).getFieldValueX(string);
            }
            return ((DescriptorSupport)this.delegate).getFieldValueX(string);
        }
        return null;
    }

    public void setField(String string, Object object) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname to be set is null"), "Exception occured trying to set a field from a descriptor");
        }
        String string2 = string.toLowerCase();
        if (this.validateField(string2, object)) {
            string2 = string2.toLowerCase();
            ArrayList arrayList = this.getDescriptor();
            Pair pair = this.findEntry(arrayList, string2);
            if (pair != null) {
                if (pair.value instanceof VoidValue) {
                    if (object == null) {
                        return;
                    }
                    --this.voidCount;
                    ++this.fieldCount;
                }
                pair.value = object;
            } else {
                if (object == null) {
                    this.removeField(string2);
                    return;
                }
                Object object2 = this.getFieldValue(string2);
                if (object.equals(object2)) {
                    return;
                }
                if (object2 instanceof String && object instanceof String && ((String)object).equalsIgnoreCase((String)object2)) {
                    return;
                }
                this.getDescriptor(true).add(new Pair(string2, object));
                if (this.delegate == null || object2 == null) {
                    ++this.fieldCount;
                }
            }
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Field value invalid: " + string2 + "=" + object), "Field " + string2 + "=" + object + " is invalid. Exception occured trying to set a field from a descriptor");
        }
    }

    private Pair findEntry(ArrayList arrayList, String string) {
        int n = this.findEntryIndex(arrayList, string);
        if (n >= 0) {
            return (Pair)arrayList.get(n);
        }
        return null;
    }

    private int findEntryIndex(ArrayList arrayList, String string) {
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (((String)pair.name).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String[] getFields() {
        String[] stringArray = this.getFieldNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.getFieldValue(stringArray[i]);
            String string = new String(stringArray[i] + "=");
            if (object != null) {
                string = object instanceof String ? string + object : string + "(" + object + ")";
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public String[] getFieldNames() {
        Vector vector = new Vector(this.getFieldCount() + this.getVoidCount());
        this.getFieldNamesI(vector);
        String[] stringArray = vector.toArray(new String[vector.size()]);
        return stringArray;
    }

    private void getFieldNamesI(Vector vector) {
        if (this.delegate != null) {
            if (this.delegate instanceof DescriptorSupportBase) {
                ((DescriptorSupportBase)this.delegate).getFieldNamesI(vector);
            } else if (this.delegate instanceof DescriptorSupport) {
                ((DescriptorSupport)this.delegate).getFieldNamesI(vector);
            }
        }
        ArrayList arrayList = this.getDescriptor();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.value instanceof VoidValue) {
                vector.remove(pair.name);
                continue;
            }
            if (vector.contains(pair.name)) continue;
            vector.add(pair.name);
        }
    }

    protected void mergeDescriptors(DescriptorSupport descriptorSupport) {
        Object[] objectArray = descriptorSupport.getFieldPairs();
        for (int i = 0; i < objectArray.length; ++i) {
            Pair pair = (Pair)objectArray[i];
            if (pair == null) continue;
            Object object = this.getFieldValue((String)pair.name);
            if (object == null) {
                this.setField((String)pair.name, pair.value);
                continue;
            }
            if (object.equals(pair.value)) continue;
            this.setField((String)pair.name, pair.value);
        }
    }

    protected Object[] getFieldPairs() {
        int n = this.getFieldCount() + this.getVoidCount();
        HashMap hashMap = new HashMap(n + 10);
        this.getFieldPairsI(hashMap);
        return hashMap.values().toArray(new Pair[n]);
    }

    private void getFieldPairsI(HashMap hashMap) {
        if (this.delegate != null) {
            if (this.delegate instanceof DescriptorSupportBase) {
                ((DescriptorSupportBase)this.delegate).getFieldPairsI(hashMap);
            } else if (this.delegate instanceof DescriptorSupport) {
                ((DescriptorSupport)this.delegate).getFieldPairsI(hashMap);
            }
        }
        ArrayList arrayList = this.getDescriptor();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.value instanceof VoidValue) {
                hashMap.remove(pair.name);
                continue;
            }
            if (hashMap.containsValue(pair.name)) continue;
            hashMap.put(pair.name, pair);
        }
    }

    public Object[] getFieldValues(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Object[] objectArray = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = stringArray[i] == null || stringArray[i].equals("") ? null : this.getFieldValue(stringArray[i]);
        }
        return objectArray;
    }

    public void setFields(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (stringArray == null && objectArray == null || stringArray.length == 0 && objectArray.length == 0) {
            return;
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames and FieldValues are null or invalid"), "Exception occured trying to set object fields a descriptor");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames is null or invalid"), "Exception occured trying to set object fields a descriptor");
            }
            this.setField(stringArray[i], objectArray[i]);
        }
    }

    public Object clone() throws RuntimeOperationsException {
        return new DescriptorSupport(this);
    }

    public void removeField(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        ArrayList arrayList = this.getDescriptor(true);
        int n = this.findEntryIndex(arrayList, string);
        Pair pair = n >= 0 ? arrayList.get(n) : null;
        if (pair != null && pair.value instanceof VoidValue) {
            return;
        }
        Object object = null;
        if (this.delegate != null) {
            object = this.delegate.getFieldValue(string);
        }
        if (object != null) {
            if (n >= 0) {
                pair.value = voidValue;
            } else {
                arrayList.add(new Pair(string, voidValue));
            }
            --this.fieldCount;
            ++this.voidCount;
        } else if (n >= 0) {
            arrayList.remove(n);
            --this.fieldCount;
        }
    }

    public boolean isValid() throws RuntimeOperationsException {
        Object object;
        Object object2;
        if (this.delegate == null) {
            object2 = (String)this.getFieldValue("name");
            object = (String)this.getFieldValue("descriptorType");
            if (object2 == null || object == null || ((String)object2).equals("") || ((String)object).equals("")) {
                return false;
            }
        }
        object2 = this.getDescriptor().iterator();
        while (object2.hasNext()) {
            object = (Pair)object2.next();
            if (((Pair)object).value == null || this.validateField(((Pair)object).name.toString(), ((Pair)object).value.toString())) continue;
            return false;
        }
        return true;
    }

    private boolean validateField(String string, Object object) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = "";
        boolean bl = false;
        if (object != null && object instanceof String) {
            string2 = (String)object;
            bl = true;
        }
        if (string.equalsIgnoreCase("Name") || string.equalsIgnoreCase("DescriptorType") || string.equalsIgnoreCase("SetMethod") || string.equalsIgnoreCase("GetMethod") || string.equalsIgnoreCase("Role") || string.equalsIgnoreCase("Class")) {
            return object != null && bl;
        }
        if (string.equalsIgnoreCase("visibility")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= 1 && n <= 4;
        }
        if (string.equalsIgnoreCase("severity")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= 0 && n <= 5;
        }
        if (string.equalsIgnoreCase("PersistPolicy")) {
            return object != null && bl && (string2.equalsIgnoreCase("OnUpdate") || string2.equalsIgnoreCase("OnTimer") || string2.equalsIgnoreCase("NoMoreOftenThan") || string2.equalsIgnoreCase("Always") || string2.equalsIgnoreCase("Never"));
        }
        if (string.equalsIgnoreCase("PersistPeriod") || string.equalsIgnoreCase("CurrencyTimeLimit") || string.equalsIgnoreCase("LastUpdatedTimeStamp") || string.equalsIgnoreCase("LastReturnedTimeStamp")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= -1;
        }
        if (string.equalsIgnoreCase("ReadOnly") || string.equalsIgnoreCase("log") || string.equalsIgnoreCase("Iterable")) {
            return object instanceof Boolean || bl && (string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("F") || string2.equalsIgnoreCase("false"));
        }
        return true;
    }

    public String toXMLString() {
        String string = new String("<Descriptor>");
        int n = this.getDescriptor().size();
        if (n == 0) {
            return null;
        }
        Iterator iterator = this.getDescriptor().iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.value == null) {
                string = string + "<field name=\"" + pair.name.toString() + "\" value=\"null\"></field>";
                continue;
            }
            string = string + "<field name=\"" + pair.name.toString() + "\" value=\"" + pair.value.toString() + "\"></field>";
        }
        string = string + "</Descriptor>";
        return string;
    }

    public String toString() {
        String string = "";
        String[] stringArray = this.getFields();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = i == stringArray.length - 1 ? string.concat(stringArray[i]) : string.concat(stringArray[i] + ", ");
        }
        return string;
    }

    private int toNumeric(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
        return n;
    }

    void setDelegate(DescriptorSupport descriptorSupport) {
        this.delegate = descriptorSupport;
    }

    DescriptorSupport getDelegate() {
        return (DescriptorSupport)this.delegate;
    }

    void removeDefaults() {
        DescriptorSupport descriptorSupport = this.getDelegate();
        if (descriptorSupport != null) {
            if (descriptorSupport instanceof DescriptorSupportBase) {
                this.setDelegate(null);
            } else {
                descriptorSupport.removeDefaults();
            }
        }
    }

    void restoreDefaults(DescriptorSupportBase descriptorSupportBase) throws MBeanException {
        String[] stringArray = descriptorSupportBase.getFieldNames();
        DescriptorSupport descriptorSupport = this.restoreDefaultX(this, stringArray);
        if (descriptorSupport != null) {
            descriptorSupport.setDelegate(descriptorSupportBase);
        }
    }

    private DescriptorSupport restoreDefaultX(DescriptorSupport descriptorSupport, String[] stringArray) {
        DescriptorSupport descriptorSupport2 = descriptorSupport.getDelegate();
        if (descriptorSupport2 == null) {
            this.restoreCountsForNewDefault(descriptorSupport, stringArray);
            return descriptorSupport;
        }
        if (descriptorSupport2 instanceof DescriptorSupportBase) {
            return null;
        }
        DescriptorSupport descriptorSupport3 = this.restoreDefaultX(descriptorSupport2, stringArray);
        if (descriptorSupport3 != null) {
            this.restoreCountsForNewDefault(descriptorSupport, stringArray);
        }
        return descriptorSupport3;
    }

    private void restoreCountsForNewDefault(DescriptorSupport descriptorSupport, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = descriptorSupport.testFieldStatus(string);
            if (n != 0) continue;
            ++this.fieldCount;
        }
    }

    private int testFieldStatus(String string) {
        Pair pair = this.findEntry(this.getDescriptor(), string.toLowerCase());
        if (pair != null && pair.value != null) {
            if (pair.value instanceof VoidValue) {
                return -1;
            }
            return 1;
        }
        if (this.delegate != null) {
            return ((DescriptorSupport)this.delegate).testFieldStatus(string);
        }
        return 0;
    }

    void prepareNewPrimaryDelegate(DescriptorSupport descriptorSupport) {
        descriptorSupport.setDelegate(null);
        String[] stringArray = descriptorSupport.getFields();
        descriptorSupport.fieldCount = this.fieldCount;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = this.testFieldStatus(string);
            if (n != 0) continue;
            ++this.fieldCount;
        }
        DescriptorSupport descriptorSupport2 = this;
        while (descriptorSupport2 != null && descriptorSupport2 instanceof DescriptorSupport && descriptorSupport2.getFieldCountLocal() == 0) {
            descriptorSupport2 = (DescriptorSupport)descriptorSupport2.delegate;
        }
        descriptorSupport.setDelegate(descriptorSupport2);
    }

    boolean isBaseDelegate() {
        DescriptorSupport descriptorSupport = this.getDelegate();
        if (descriptorSupport == null) {
            return true;
        }
        return descriptorSupport instanceof DescriptorSupportBase;
    }

    private static class VoidValue
    implements Serializable {
        private static final long serialVersionUID = 8080916936062268943L;

        private VoidValue() {
        }
    }

    protected class Pair
    implements Serializable {
        protected static final long serialVersionUID = -2343447898010660137L;
        Object name;
        Object value;

        protected Pair(Object object, Object object2) {
            this.name = object;
            this.value = object2;
        }
    }
}

