/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.management.commo.AbstractCodeGenerator;
import weblogic.management.commo.WebLogicMBeanMaker;
import weblogic.utils.PlatformConstants;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;

public class ImplCodeGenerator
extends AbstractCodeGenerator
implements PlatformConstants {
    CodeGenerator.Output currentOutput = null;

    ImplCodeGenerator(WebLogicMBeanMaker webLogicMBeanMaker) {
        super(webLogicMBeanMaker);
    }

    protected Enumeration outputs(Object[] objectArray) throws Exception {
        int n = 0;
        if (n < objectArray.length) {
            String string = (String)objectArray[n];
            Vector<AbstractCodeGenerator.Output> vector = new Vector<AbstractCodeGenerator.Output>();
            AbstractCodeGenerator.Output output = new AbstractCodeGenerator.Output(string + "Impl.java", "CustomMBeanImpl.j", "");
            vector.add(output);
            return vector.elements();
        }
        return null;
    }

    protected void prepare(CodeGenerator.Output output) throws Exception {
        this.currentOutput = output;
    }

    public String packageDescriptor() {
        String string = "";
        if (this.tool.getMBeanPackageName() != null) {
            try {
                string = string + this.parse(this.getProductionRule("package"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String implementsSpec() {
        String string = "";
        Enumeration enumeration = this.tool.implementsSet.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ", " + ((Node)enumeration.nextElement()).getFirstChild().getNodeValue() + "MBean";
        }
        return string;
    }

    public String requiredModelMBeanSpec() {
        if (this.getDValue("Extends") == null) {
            return "protected ModelMBean requiredModelMBean = null; public ModelMBean getRequiredModelMBean() { return requiredModelMBean; }";
        }
        return "";
    }

    public String extendsSpec() {
        String string = this.getDValue("Extends");
        if (string != null) {
            return "extends " + string + "Impl";
        }
        return "";
    }

    public String constructorBody() {
        String string = this.getDValue("Extends");
        if (string != null) {
            return "super(base);";
        }
        return "super(); requiredModelMBean = (ModelMBean)base;";
    }

    public String mBeanName() {
        return this.tool.mBeanName();
    }

    public String versionID() {
        String string = this.getDValue("VersionID");
        if (string == null) {
            string = "1L";
        }
        return string;
    }

    public String mBeanImplFileName() {
        return this.tool.mBeanName() + "Impl";
    }

    public String delegateClassName() {
        return this.tool.mBeanName() + "Impl";
    }

    public String mBeanDescriptors() {
        String string = "";
        NamedNodeMap namedNodeMap = this.tool.root.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node;
            this.currentTag = node = namedNodeMap.item(i);
            string = string + this.handleMBeanTag();
        }
        return string;
    }

    public String packageName() {
        return this.tool.getMBeanPackageName();
    }

    public String generatedMethods() {
        return "";
    }

    public String CheckMBeanListenerRegistration() {
        String string = "";
        return string;
    }

    public String CheckMBeanListener() {
        String string = "";
        return string;
    }

    public String attributeDefinitions() {
        String string = "";
        return string;
    }

    public String tagName() {
        return this.lowerCaseFirst(this.currentTag.getNodeName());
    }

    String lowerCaseFirst(String string) {
        String string2 = string.substring(0, 1).toLowerCase();
        if (string.length() > 1) {
            string2 = string2 + string.substring(1);
        }
        return string2;
    }

    public String tagValue() {
        return this.currentTag.getNodeValue();
    }

    String collapse(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String attributeVariableList() {
        String string = "";
        Enumeration enumeration = this.tool.attributes.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                String string2 = this.parse(this.getProductionRule("attributeVariable") + ",");
                string = string + "          " + this.collapse(string2) + PlatformConstants.EOL;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    public String attributeVariable() {
        return "mmai_" + this.objectName();
    }

    public String attributeTypeSimple() {
        String string = this.attributeType();
        return string.substring(0, string.indexOf("["));
    }

    public String operationDefinitionsPerAccessors() {
        String string = "";
        Enumeration enumeration = this.tool.attributes.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            boolean bl = false;
            if (this.getAValue("GetMethod") != null) {
                try {
                    string = string + this.parse(this.getProductionRule("operationGetterDefinition"));
                    bl = true;
                }
                catch (CodeGenerationException codeGenerationException) {
                    codeGenerationException.printStackTrace();
                }
            }
            if (this.getAValue("SetMethod") != null) {
                try {
                    string = string + this.parse(this.getProductionRule("operationSetterDefinition"));
                    bl = true;
                }
                catch (CodeGenerationException codeGenerationException) {
                    codeGenerationException.printStackTrace();
                }
            }
            if (this.tool.isArray(this.currentObject) && this.getAValueBool("GenerateExtendedAccessors")) {
                try {
                    string = string + this.parse(this.getProductionRule("operationElementAcessorDefinitions"));
                    bl = true;
                }
                catch (CodeGenerationException codeGenerationException) {
                    codeGenerationException.printStackTrace();
                }
            }
            if (!bl) continue;
            ++this.count;
        }
        return string;
    }

    public String operationParamTypeList() {
        String string = "";
        Vector vector = this.tool.getParameterTypes(this.currentObject);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + this.getType(string2) + ", ";
        }
        return string;
    }

    public String operationReturnValue() {
        return this.returnValue(this.operationReturnType());
    }

    public String attributeValue() {
        return this.returnValue(this.attributeType());
    }

    String returnValue(String string) {
        String string2 = string.trim();
        if (string2.trim().equals("int")) {
            return "0";
        }
        if (string2.trim().equals("boolean")) {
            return "false";
        }
        if (string2.trim().equals("long")) {
            return "0";
        }
        if (string2.trim().equals("float")) {
            return "0";
        }
        if (string2.trim().equals("double")) {
            return "0";
        }
        if (string2.trim().equals("character")) {
            return "''";
        }
        if (string2.trim().equals("byte")) {
            return "0";
        }
        if (string2.trim().equals("short")) {
            return "0";
        }
        return "null";
    }

    public String operationDefinitions() {
        this.count = 1;
        String string = "";
        Enumeration enumeration = this.tool.operations.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                string = string + this.parse(this.getProductionRule("operationDefinition"));
                ++this.count;
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String operationMethods() {
        String string = "";
        Enumeration enumeration = this.tool.operations.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                string = string + this.parse(this.getProductionRule("operationMethodDefinition"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String constructorMethods() {
        String string = "";
        Enumeration enumeration = this.tool.constructors.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                string = string + this.parse(this.getProductionRule("constructorMethodDefinition"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String attributeAccessorMethods() {
        String string = "";
        Enumeration enumeration = this.tool.attributes.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                boolean bl = this.getAValueBool("Readable");
                bl = true;
                String string2 = this.getAValue("GetMethod");
                if (bl && string2 != null) {
                    string = string + this.parse(this.getProductionRule("getterMethodDefinition"));
                }
                boolean bl2 = this.getAValueBool("Writeable");
                bl2 = true;
                String string3 = this.getAValue("SetMethod");
                if (bl2 && string3 != null) {
                    string = string + this.parse(this.getProductionRule("setterMethodDefinition"));
                }
                String string4 = this.getAValue("Validator");
                if (!bl2 || string4 == null) continue;
                string = string + this.parse(this.getProductionRule("validatorMethodDefinition"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String attributeArrayAccessorMethods() {
        String string = "";
        Enumeration enumeration = this.tool.attributes.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                boolean bl;
                boolean bl2 = this.getAValueBool("GenerateExtendedAccessors");
                boolean bl3 = this.getAValueBool("Readable");
                if (bl3 && bl2 && this.tool.isArray(this.currentObject)) {
                    string = string + this.parse(this.getProductionRule("arrayIndexGetterMethodDefinition"));
                }
                if (!(bl = this.getAValueBool("Writeable")) || !bl2 || !this.tool.isArray(this.currentObject)) continue;
                string = string + this.parse(this.getProductionRule("arrayIndexSetterMethodDefinition"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String operationVariableList() {
        this.count = 1;
        String string = "";
        Enumeration enumeration = this.tool.operations.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                String string2 = this.parse(this.getProductionRule("operationVariable") + ",");
                string = string + "          " + this.collapse(string2) + PlatformConstants.EOL;
                ++this.count;
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        enumeration = this.tool.attributes.elements();
        while (enumeration.hasMoreElements()) {
            String string3;
            this.currentObject = (Node)enumeration.nextElement();
            boolean bl = false;
            if (this.getAValue("GetMethod") != null) {
                try {
                    string3 = this.parse(this.getProductionRule("operationGetterVariable") + ",");
                    string = string + "          " + this.collapse(string3) + PlatformConstants.EOL;
                    bl = true;
                }
                catch (CodeGenerationException codeGenerationException) {
                    codeGenerationException.printStackTrace();
                }
            }
            if (this.getAValue("SetMethod") != null) {
                try {
                    string3 = this.parse(this.getProductionRule("operationSetterVariable") + ",");
                    string = string + "          " + this.collapse(string3) + PlatformConstants.EOL;
                    bl = true;
                }
                catch (CodeGenerationException codeGenerationException) {
                    codeGenerationException.printStackTrace();
                }
            }
            if (this.tool.isArray(this.currentObject) && this.getAValueBool("GenerateExtendedAccessors")) {
                try {
                    string3 = this.parse(this.getProductionRule("operationIndexGetterVariable") + ",");
                    string = string + "          " + this.collapse(string3) + PlatformConstants.EOL;
                    string3 = this.parse(this.getProductionRule("operationIndexSetterVariable") + ",");
                    string = string + "          " + this.collapse(string3) + PlatformConstants.EOL;
                    bl = true;
                }
                catch (CodeGenerationException codeGenerationException) {
                    codeGenerationException.printStackTrace();
                }
            }
            if (!bl) continue;
            ++this.count;
        }
        return string;
    }

    public String operationsList() {
        String string = "";
        Enumeration enumeration = this.tool.operations.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                string = string + this.parse(this.getProductionRule("operation"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String operationReturnType() {
        return this.getOValue("ReturnType");
    }

    public String operationBody() {
        if (this.getOValue("ReturnType").equals("void")) {
            return "";
        }
        String string = "                " + this.operationReturnType() + " returnValue = " + this.operationReturnValue() + ";\n\n";
        string = string + "                // &&& add your code here\n\n";
        string = string + "                return returnValue;\n";
        return string;
    }

    public String operationParams() {
        String string = "";
        NodeList nodeList = this.currentObject.getChildNodes();
        boolean bl = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("MBeanOperationArg")) continue;
            this.currentParam = node;
            if (!bl) {
                string = string + ", ";
            }
            bl = false;
            string = string + this.paramType() + " " + this.paramName();
        }
        return string;
    }

    public String operationParamsDoc() {
        String string = "";
        NodeList nodeList = this.currentObject.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("MBeanOperationArg")) continue;
            this.currentParam = node;
            try {
                string = string + this.parse(this.getProductionRule("operationParamDoc"));
                continue;
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String paramName() {
        return this.tool.attrVal(this.currentParam, "Name");
    }

    public String paramType() {
        return this.tool.attrVal(this.currentParam, "Type");
    }

    public String paramDescription() {
        String string = null;
        string = this.tool.attrVal(this.currentParam, "Description");
        if (string == null) {
            string = "No description provided.";
        }
        return string;
    }

    public String operationExceptions() {
        String string = "";
        NodeList nodeList = this.currentObject.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("MBeanException")) continue;
            string = string + ", ";
            string = string + node.getFirstChild().getNodeValue();
        }
        return string;
    }

    public String operationExceptionsDoc() {
        String string = "";
        NodeList nodeList = this.currentObject.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("MBeanException")) continue;
            this.currentException = node;
            try {
                string = string + this.parse(this.getProductionRule("operationExceptionDoc"));
                continue;
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String exceptionName() {
        return this.currentException.getFirstChild().getNodeValue();
    }

    public String imports() {
        String string = "";
        Enumeration enumeration = this.tool.imports.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                string = string + this.parse(this.getProductionRule("import"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String importName() {
        return this.currentObject.getFirstChild().getNodeValue();
    }

    public String constructorDefinitions() {
        this.count = 1;
        String string = "";
        Enumeration enumeration = this.tool.constructors.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                string = string + this.parse(this.getProductionRule("constructorDefinition"));
                ++this.count;
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String constructorVariableList() {
        this.count = 1;
        String string = "";
        Enumeration enumeration = this.tool.constructors.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                String string2 = this.parse(this.getProductionRule("constructorVariable") + ",");
                string = string + "          " + this.collapse(string2) + PlatformConstants.EOL;
                ++this.count;
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
        }
        return string;
    }

    public String notificationClassName() {
        String string = this.className();
        if (string == null) {
            string = this.packageName() + ".GeneratedNotificationClass" + this.count();
        }
        return string;
    }

    public String notificationDefinitions() {
        this.count = 1;
        String string = "";
        Enumeration enumeration = this.tool.notifications.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                string = string + this.parse(this.getProductionRule("notificationDefinition"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
            ++this.count;
        }
        return string;
    }

    public String generatedNotificationClasses() {
        this.count = 1;
        String string = "";
        Enumeration enumeration = this.tool.notifications.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            try {
                string = string + this.parse(this.getProductionRule("notificationClassDefinition"));
            }
            catch (CodeGenerationException codeGenerationException) {
                codeGenerationException.printStackTrace();
            }
            ++this.count;
        }
        return string;
    }

    public String notificationVariableList() {
        this.count = 1;
        String string = "";
        Enumeration enumeration = this.tool.notifications.elements();
        while (enumeration.hasMoreElements()) {
            this.currentObject = (Node)enumeration.nextElement();
            string = string + "          " + this.notificationVariable() + "," + PlatformConstants.EOL;
            ++this.count;
        }
        return string;
    }

    public String notificationVariable() {
        return "mmni_notification" + this.count();
    }

    public String checkAbstract() {
        String string = this.getDValue("Abstract");
        if (string == null) {
            return "";
        }
        if (string.substring(0, 0).equalsIgnoreCase("t")) {
            return "abstract";
        }
        return "";
    }

    public String attributeDescriptors() {
        String string = "";
        NamedNodeMap namedNodeMap = this.currentObject.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node;
            this.currentTag = node = namedNodeMap.item(i);
            string = string + this.handleAttributeTag();
        }
        return string;
    }

    public String notificationDescriptors() {
        String string = "";
        NamedNodeMap namedNodeMap = this.currentObject.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node;
            this.currentTag = node = namedNodeMap.item(i);
            string = string + this.handleNotificationTag();
        }
        return string;
    }

    public String operationDescriptors() {
        String string = "";
        NamedNodeMap namedNodeMap = this.currentObject.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node;
            this.currentTag = node = namedNodeMap.item(i);
            string = string + this.handleOperationTag();
        }
        return string;
    }

    public String constructorDescriptors() {
        String string = "";
        NamedNodeMap namedNodeMap = this.currentObject.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node;
            this.currentTag = node = namedNodeMap.item(i);
            string = string + this.handleConstructorTag();
        }
        return string;
    }

    String handleTagGeneral() {
        try {
            if (this.tagType().equals("String")) {
                return this.parse(this.getProductionRule("descriptorString"));
            }
            return this.parse(this.getProductionRule("descriptorOther"));
        }
        catch (Exception exception) {
            System.out.println("Cannot process tag " + this.currentTag.getNodeName() + " for item " + this.currentObject.getLocalName() + ": " + exception);
            this.tool.error = true;
            return "";
        }
    }

    public String tagType() {
        return "String";
    }

    String handleMBeanTag() {
        return this.handleTagGeneral();
    }

    String handleAttributeTag() {
        return this.handleTagGeneral();
    }

    String handleNotificationTag() {
        return this.handleTagGeneral();
    }

    String handleConstructorTag() {
        return this.handleTagGeneral();
    }

    String handleOperationTag() {
        return this.handleTagGeneral();
    }

    public static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz.equals(clazz2)) {
            return true;
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        return ImplCodeGenerator.isSubclass(clazz3, clazz2);
    }

    public String attributeGetMethodName() {
        return this.getAValue("GetMethod");
    }

    public String attributeSetMethodName() {
        return this.objectName() + "SetMethod";
    }
}

