/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import com.bea.staxb.buildtime.internal.mbean.MBeanJava2Schema;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JamServiceFactory;
import com.bea.util.jam.JamServiceParams;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.jar.JarFile;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.JarFileUtils;

public class JavaToSchemaUtil {
    static final String MBEAN_IMPL_SRC_JAR_NAME = "wlManagementImplSource.jar";
    static final String BASE_SCHEMA_JAR = "weblogic-domain-binding.jar";

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length == 3 ? stringArray[2] : null;
        JavaToSchemaUtil.generateSchema(stringArray[0], stringArray[1], string);
    }

    private static String getManagementImplSrcJarName(String string) {
        Class<?> clazz = null;
        Method method = null;
        String string2 = null;
        try {
            String string3 = System.getProperty("weblogic.SPUpgrade.FromInstaller");
            if (string3 != null) {
                string2 = System.getProperty("weblogic.SPUpgrade.MBeanImplJarPath");
            } else {
                if (string == null) {
                    string = System.getProperty("mbeantypesDir");
                }
                System.out.println("MBEAN TYPES DIR : " + string);
                if (string == null) {
                    clazz = Class.forName("weblogic.management.bootstrap.BootStrap");
                    method = clazz.getMethod("getPathRelativeWebLogicHome", String.class);
                    String string4 = (String)method.invoke(null, "lib");
                    string2 = string4 + File.separator + "mbeantypes" + File.separator + MBEAN_IMPL_SRC_JAR_NAME;
                } else {
                    string2 = string + File.separator + MBEAN_IMPL_SRC_JAR_NAME;
                }
            }
            return string2;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private static String getWebLogicHome() {
        Class<?> clazz = null;
        Method method = null;
        try {
            clazz = Class.forName("weblogic.management.bootstrap.BootStrap");
            method = clazz.getMethod("getPathRelativeWebLogicHome", String.class);
            String string = (String)method.invoke(null, "lib");
            return string;
        }
        catch (Exception exception) {
            System.out.println("WebLogic installation not found");
            return null;
        }
    }

    private static void generateSchema(String string, String string2, String string3) throws IOException {
        System.out.println("Generating schema for security provider mbeans ... ");
        String string4 = "securitySchemaTempDir";
        File file = new File(string4);
        if (file.exists()) {
            FileUtils.remove((File)file);
        }
        file.mkdir();
        File file2 = new File("tempFileDirForSchema");
        JarFile jarFile = new JarFile(new File(JavaToSchemaUtil.getManagementImplSrcJarName(string3)));
        JarFileUtils.extract((JarFile)jarFile, (File)file2);
        FileCopier fileCopier = new FileCopier();
        fileCopier.setIncludeEmptyDirs(false);
        fileCopier.setTodir(file2);
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(string));
        fileSet.setExcludes("**/*.xml");
        fileSet.setIncludes("**/*MBeanImpl.java");
        fileCopier.addFileset(fileSet);
        fileCopier.execute();
        JavaToSchemaUtil.deleteEmptyDirectories(file2);
        JavaToSchemaUtil.deleteAllExceptMBeanImplFiles(file2.getAbsolutePath(), null);
        JamServiceFactory jamServiceFactory = JamServiceFactory.getInstance();
        JamServiceParams jamServiceParams = jamServiceFactory.createServiceParams();
        jamServiceParams.includeSourcePattern(new File[]{file2}, "**/*Impl.java");
        jamServiceParams.excludeSourcePattern(new File[]{file2}, "**/*MBI.java");
        JClass[] jClassArray = jamServiceFactory.createService(jamServiceParams).getAllClasses();
        MBeanJava2Schema mBeanJava2Schema = new MBeanJava2Schema();
        for (int i = 0; i < jClassArray.length; ++i) {
            mBeanJava2Schema.addClassToBind(jClassArray[i]);
        }
        File file3 = null;
        String string5 = System.getProperty("weblogic.SPUpgrade.FromInstaller");
        if (string5 != null) {
            file3 = new File(System.getProperty("weblogic.SPUpgrade.BindingJarPath"));
        } else {
            String string6 = JavaToSchemaUtil.getWebLogicHome();
            if (string6 != null) {
                file3 = new File(string6 + "/schema/" + BASE_SCHEMA_JAR);
            }
        }
        mBeanJava2Schema.setAttributeFormDefaultQualified(false);
        mBeanJava2Schema.setElementFormDefaultQualified(true);
        if (file3 != null) {
            System.out.println("SET BASE LIB " + file3);
            mBeanJava2Schema.setBaseLibraries(new File[]{file3});
        }
        mBeanJava2Schema.bindAsExplodedTylar(new File(string));
        FileUtils.remove((File)file);
        FileUtils.remove((File)file2);
    }

    private static void deleteAllExceptMBeanImplFiles(String string, String string2) {
        String string3 = null;
        string3 = string2 == null ? string : string + File.separator + string2;
        File file = new File(string3);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = null;
            string4 = string2 != null ? string2 + File.separator + stringArray[i] : stringArray[i];
            File file2 = new File(string + File.separator + string4);
            if (file2.isDirectory()) {
                JavaToSchemaUtil.deleteAllExceptMBeanImplFiles(string, string4);
                continue;
            }
            if (file2.getName().endsWith("MBeanImpl.java")) continue;
            FileUtils.remove((File)file2);
        }
    }

    private static void deleteEmptyDirectories(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            File file2 = new File(file.getParentFile().getAbsolutePath());
            FileUtils.remove((File)file);
            JavaToSchemaUtil.deleteEmptyDirectories(file2);
        } else {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                JavaToSchemaUtil.deleteEmptyDirectories(fileArray[i]);
            }
        }
    }

    static class FileCopier
    extends Copy {
        public FileCopier() {
            this.project = new Project();
            this.project.init();
            this.taskType = "copy";
            this.taskName = "copy";
            this.target = new Target();
        }
    }
}

