/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class Classpath {
    private static Set paths;
    private static String classpath;
    private static String separator;

    public static synchronized void prepend(File file) {
        if (Classpath.alreadySeen(file)) {
            return;
        }
        try {
            String string = file.getCanonicalPath();
            classpath = string + separator + classpath;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void append(File file) {
        if (Classpath.alreadySeen(file)) {
            return;
        }
        try {
            String string = file.getCanonicalPath();
            classpath = classpath + separator + string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized String append(String string, String string2) {
        return string + separator + string2;
    }

    public static synchronized String get() {
        return classpath;
    }

    private static boolean alreadySeen(File file) {
        if (paths.contains(file)) {
            return true;
        }
        paths.add(file);
        return false;
    }

    static {
        String string;
        paths = new HashSet();
        classpath = null;
        separator = System.getProperty("path.separator");
        classpath = string = System.getProperty("java.class.path");
        String string2 = System.getProperty("sun.boot.class.path");
        if (string2 != null) {
            classpath = string2 + separator + classpath;
        }
    }
}

