/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import weblogic.utils.UnsyncStringBuffer;

public final class StringUtils {
    private static final StringMaker stringMaker;
    private static final int HI_BYTE = 0;
    private static final boolean USE_DEPRECATED = true;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";

    private StringUtils() {
    }

    public static String[] split(String string, char c) {
        String[] stringArray = new String[]{string, ""};
        int n = string.indexOf(c);
        if (n != -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        return stringArray;
    }

    public static String[] splitCompletely(String string, String string2, boolean bl) {
        return StringUtils.splitCompletely(new StringTokenizer(string, string2, bl));
    }

    public static String[] splitCompletely(String string, String string2) {
        return StringUtils.splitCompletely(new StringTokenizer(string, string2));
    }

    public static String[] splitCompletely(String string) {
        return StringUtils.splitCompletely(new StringTokenizer(string));
    }

    private static String[] splitCompletely(StringTokenizer stringTokenizer) {
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String[] splitPartially(String string, String string2, int n) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n2 = stringTokenizer.countTokens();
        if (n == 0 || n >= n2) {
            stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        } else {
            stringArray = new String[n];
            for (int i = 0; i < n - 1; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            stringArray[i] = stringTokenizer.nextToken() + stringTokenizer.nextToken("");
        }
        return stringArray;
    }

    public static String join(String[] stringArray, String string) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return StringUtils.join(stringArray, string, 0, stringArray.length);
    }

    public static String join(String[] stringArray, String string, int n, int n2) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer();
        for (int i = n; i < n2; ++i) {
            unsyncStringBuffer.append(stringArray[i]);
            if (i >= n2 - 1) continue;
            unsyncStringBuffer.append(string);
        }
        return unsyncStringBuffer.toString();
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtils.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n) {
        for (int i = n; i < string.length() - string2.length() + 1; ++i) {
            if (!string.regionMatches(true, i, string2, 0, string2.length())) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String string, String string2) {
        return StringUtils.lastIndexOfIgnoreCase(string, string2, 0);
    }

    public static int lastIndexOfIgnoreCase(String string, String string2, int n) {
        for (int i = string.length() - string2.length(); i >= n; --i) {
            if (!string.regionMatches(true, i, string2, 0, string2.length())) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWith(String string, char c) {
        return string.length() > 0 && string.charAt(0) == c;
    }

    public static boolean endsWith(String string, char c) {
        return string.length() > 0 && string.charAt(string.length() - 1) == c;
    }

    public static String upto(String string, char c) {
        int n = string.indexOf(c);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String ucfirst(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String escapeString(String string) {
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer(string.length());
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    unsyncStringBuffer.append("\\b");
                    continue block10;
                }
                case '\t': {
                    unsyncStringBuffer.append("\\t");
                    continue block10;
                }
                case '\n': {
                    unsyncStringBuffer.append("\\n");
                    continue block10;
                }
                case '\f': {
                    unsyncStringBuffer.append("\\f");
                    continue block10;
                }
                case '\r': {
                    unsyncStringBuffer.append("\\r");
                    continue block10;
                }
                case '\"': {
                    unsyncStringBuffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    unsyncStringBuffer.append("\\'");
                    continue block10;
                }
                case '\\': {
                    unsyncStringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    unsyncStringBuffer.append(c);
                }
            }
        }
        return unsyncStringBuffer.toString();
    }

    public static String valueOf(int n) {
        boolean bl;
        char[] cArray = new char[11];
        int n2 = cArray.length;
        boolean bl2 = bl = n < 0;
        if (!bl) {
            n = -n;
        }
        while (n <= -10) {
            cArray[--n2] = Character.forDigit(-(n % 10), 10);
            n /= 10;
        }
        cArray[--n2] = Character.forDigit(-n, 10);
        if (bl) {
            cArray[--n2] = 45;
        }
        return StringUtils.getString(cArray, n2, cArray.length - n2);
    }

    public static String valueOf(Object object) {
        return object == null ? "" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(cArray);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String padStringWidth(String string, int n) {
        UnsyncStringBuffer unsyncStringBuffer;
        if (string != null) {
            int n2;
            unsyncStringBuffer = new UnsyncStringBuffer(string);
            unsyncStringBuffer.setLength(n);
            for (int i = n2 = string.length(); i < n; ++i) {
                unsyncStringBuffer.setCharAt(i, ' ');
            }
        } else {
            unsyncStringBuffer = new UnsyncStringBuffer(n);
            for (int i = 0; i < n; ++i) {
                unsyncStringBuffer.setCharAt(i, ' ');
            }
        }
        return unsyncStringBuffer.toString();
    }

    public static String padStringWidth(int n, int n2) {
        return StringUtils.padStringWidth(String.valueOf(n), n2);
    }

    public static String padStringWidth(float f, int n) {
        return StringUtils.padStringWidth(String.valueOf(f), n);
    }

    public static String padStringWidth(long l, int n) {
        return StringUtils.padStringWidth(String.valueOf(l), n);
    }

    public static String padStringWidth(double d, int n) {
        return StringUtils.padStringWidth(String.valueOf(d), n);
    }

    public static String padNumberWidth(long l, int n) {
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer(n);
        for (int i = n - 1; i >= 0; --i) {
            long l2 = (long)Math.pow(10.0, i);
            long l3 = l / l2;
            unsyncStringBuffer.append(l3);
            l -= l3 * l2;
        }
        return unsyncStringBuffer.toString();
    }

    public static String replaceGlobal(String string, String string2, String string3) {
        int n;
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) >= 0) {
            unsyncStringBuffer.append(string.substring(n2, n));
            unsyncStringBuffer.append(string3);
            n2 = n + string2.length();
        }
        unsyncStringBuffer.append(string.substring(n2));
        return unsyncStringBuffer.toString();
    }

    public static boolean isEmptyString(String string) {
        return string == null || string.length() == 0 || StringUtils.isWhitespace(string);
    }

    public static boolean isWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String mangle(String string) {
        char[] cArray = string.toCharArray();
        long l = 0L;
        for (int i = 0; i < cArray.length; ++i) {
            l = 129L * l + (long)cArray[i];
        }
        return Long.toString(l, 36);
    }

    public static String formatLines(String string, int n, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        int n4 = 0;
        while (n3 != -1) {
            String string2 = string.substring(n2, n3);
            if ((n4 += string2.length()) >= n) {
                stringBuffer.append("\n");
                n4 = string2.length();
            }
            stringBuffer.append(string2);
            if (string2.indexOf("\n") >= 0) {
                n4 = 0;
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        return new String(stringBuffer);
    }

    public static int getUTFLength(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    public static String getString(byte[] byArray) {
        return StringUtils.getString(byArray, 0, byArray.length);
    }

    public static String getString(byte[] byArray, int n, int n2) {
        return new String(byArray, 0, n, n2);
    }

    public static String getString(char[] cArray, int n, int n2) {
        return stringMaker.getString(cArray, n, n2);
    }

    public static boolean strcmp(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return string2.equals(string);
        }
        return string.equals(string2);
    }

    static {
        Constructor constructor = null;
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, new char[0].getClass()};
            constructor = String.class.getDeclaredConstructor(classArray);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        stringMaker = constructor == null ? new StringMaker() : new ReflectedStringMaker(constructor);
    }

    private static class ReflectedStringMaker
    extends StringMaker {
        private final Constructor constructor;

        ReflectedStringMaker(Constructor constructor) {
            this.constructor = constructor;
        }

        public String getString(char[] cArray, int n, int n2) {
            if (n2 < 512) {
                return super.getString(cArray, n, n2);
            }
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), cArray};
            try {
                return (String)this.constructor.newInstance(objectArray);
            }
            catch (InstantiationException instantiationException) {
                return super.getString(cArray, n, n2);
            }
            catch (IllegalAccessException illegalAccessException) {
                return super.getString(cArray, n, n2);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
        }
    }

    private static class StringMaker {
        private StringMaker() {
        }

        public String getString(char[] cArray, int n, int n2) {
            return new String(cArray, n, n2);
        }
    }
}

