/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public final class CopyOnWriteArrayList
implements List,
RandomAccess,
Cloneable {
    private volatile transient Object[] array;

    public CopyOnWriteArrayList() {
        this.array = new Object[0];
    }

    public CopyOnWriteArrayList(Collection collection) {
        this.array = new Object[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.array[n++] = iterator.next();
        }
    }

    public CopyOnWriteArrayList(Object[] objectArray) {
        this.array = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.array, 0, objectArray.length);
    }

    public int size() {
        return this.array.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        Object[] objectArray = this.array;
        int n = objectArray.length;
        return CopyOnWriteArrayList.indexOf(object, objectArray, n) >= 0;
    }

    public int indexOf(Object object) {
        Object[] objectArray = this.array;
        int n = objectArray.length;
        return CopyOnWriteArrayList.indexOf(object, objectArray, n);
    }

    private static int indexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(Object object, int n) {
        Object[] objectArray = this.array;
        int n2 = objectArray.length;
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        Object[] objectArray = this.array;
        int n = objectArray.length;
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, n);
    }

    private static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = n - 1; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object, int n) {
        Object[] objectArray = this.array;
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            Object[] objectArray = this.array;
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.array = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, copyOnWriteArrayList.array, 0, objectArray.length);
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = this.array;
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = this.array;
        if (objectArray.length < objectArray2.length) {
            Array.newInstance(objectArray.getClass().getComponentType(), objectArray2.length);
        }
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        if (objectArray.length > objectArray2.length) {
            objectArray[objectArray2.length] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        Object[] objectArray = this.array;
        CopyOnWriteArrayList.rangeCheck(n, objectArray.length);
        return objectArray[n];
    }

    public synchronized Object set(int n, Object object) {
        boolean bl;
        int n2 = this.array.length;
        CopyOnWriteArrayList.rangeCheck(n, n2);
        Object object2 = this.array[n];
        boolean bl2 = bl = object2 == object || object != null && object.equals(object2);
        if (!bl) {
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.array, 0, objectArray, 0, n2);
            objectArray[n] = object;
            this.array = objectArray;
        }
        return object2;
    }

    public synchronized boolean add(Object object) {
        int n = this.array.length;
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.array, 0, objectArray, 0, n);
        objectArray[n] = object;
        this.array = objectArray;
        return true;
    }

    public synchronized void add(int n, Object object) {
        int n2 = this.array.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        Object[] objectArray = new Object[n2 + 1];
        System.arraycopy(this.array, 0, objectArray, 0, n);
        objectArray[n] = object;
        System.arraycopy(this.array, n, objectArray, n + 1, n2 - n);
        this.array = objectArray;
    }

    public synchronized Object remove(int n) {
        int n2 = this.array.length;
        CopyOnWriteArrayList.rangeCheck(n, n2);
        Object object = this.array[n];
        Object[] objectArray = new Object[n2 - 1];
        System.arraycopy(this.array, 0, objectArray, 0, n);
        int n3 = n2 - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.array, n + 1, objectArray, n, n3);
        }
        this.array = objectArray;
        return object;
    }

    public synchronized boolean remove(Object object) {
        int n = this.array.length;
        if (n == 0) {
            return false;
        }
        int n2 = n - 1;
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            if (object == this.array[i] || object != null && object.equals(this.array[i])) {
                for (int j = i + 1; j < n; ++j) {
                    objectArray[j - 1] = this.array[j];
                }
                this.array = objectArray;
                return true;
            }
            objectArray[i] = this.array[i];
        }
        if (object == this.array[n2] || object != null && object.equals(this.array[n2])) {
            this.array = objectArray;
            return true;
        }
        return false;
    }

    private synchronized void removeRange(int n, int n2) {
        int n3 = this.array.length;
        if (n < 0 || n >= n3 || n2 > n3 || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        int n5 = n3 - (n2 - n);
        Object[] objectArray = new Object[n5];
        System.arraycopy(this.array, 0, objectArray, 0, n);
        System.arraycopy(this.array, n2, objectArray, n, n4);
        this.array = objectArray;
    }

    public synchronized boolean addIfAbsent(Object object) {
        int n = this.array.length;
        Object[] objectArray = new Object[n + 1];
        for (int i = 0; i < n; ++i) {
            if (object == this.array[i] || object != null && object.equals(this.array[i])) {
                return false;
            }
            objectArray[i] = this.array[i];
        }
        objectArray[n] = object;
        this.array = objectArray;
        return true;
    }

    public boolean containsAll(Collection collection) {
        Object[] objectArray = this.array;
        int n = objectArray.length;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(iterator.next(), objectArray, n) >= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAll(Collection collection) {
        Object[] objectArray = this.array;
        int n = objectArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (collection.contains(object)) continue;
            objectArray2[n2++] = object;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray3 = new Object[n2];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
        this.array = objectArray3;
        return true;
    }

    public synchronized boolean retainAll(Collection collection) {
        Object[] objectArray = this.array;
        int n = objectArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (!collection.contains(object)) continue;
            objectArray2[n2++] = object;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray3 = new Object[n2];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
        this.array = objectArray3;
        return true;
    }

    public synchronized int addAllAbsent(Collection collection) {
        int n = collection.size();
        if (n == 0) {
            return 0;
        }
        Object[] objectArray = this.array;
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n];
        int n3 = 0;
        Object[] objectArray3 = collection.iterator();
        while (objectArray3.hasNext()) {
            Object e = objectArray3.next();
            if (CopyOnWriteArrayList.indexOf(e, objectArray, n2) >= 0 || CopyOnWriteArrayList.indexOf(e, objectArray2, n3) >= 0) continue;
            objectArray2[n3++] = e;
        }
        if (n3 == 0) {
            return 0;
        }
        objectArray3 = new Object[n2 + n3];
        System.arraycopy(objectArray, 0, objectArray3, 0, n2);
        System.arraycopy(objectArray2, 0, objectArray3, n2, n3);
        this.array = objectArray3;
        return n3;
    }

    public synchronized void clear() {
        this.array = new Object[0];
    }

    public synchronized boolean addAll(Collection collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        int n2 = this.array.length;
        Object[] objectArray = new Object[n2 + n];
        System.arraycopy(this.array, 0, objectArray, 0, n2);
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[n2++] = iterator.next();
        }
        this.array = objectArray;
        return true;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        int n2 = this.array.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n2 + n3];
        System.arraycopy(this.array, 0, objectArray, 0, n2);
        int n4 = n2 - n;
        if (n4 > 0) {
            System.arraycopy(this.array, n, objectArray, n + n3, n4);
        }
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n3; ++i) {
            objectArray[n++] = iterator.next();
        }
        this.array = objectArray;
        return true;
    }

    private static void rangeCheck(int n, int n2) {
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("[");
        int n = this.size() - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public Iterator iterator() {
        return new COWIterator(this.array, 0);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.array, 0);
    }

    public ListIterator listIterator(int n) {
        Object[] objectArray = this.array;
        int n2 = objectArray.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new COWIterator(this.array, n);
    }

    public synchronized List subList(int n, int n2) {
        int n3 = this.array.length;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, n, n2);
    }

    private static final class COWSubListIterator
    implements ListIterator {
        private final ListIterator i;
        private final int offset;
        private final int size;

        private COWSubListIterator(List list, int n, int n2, int n3) {
            this.offset = n2;
            this.size = n3;
            this.i = list.listIterator(n + n2);
        }

        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public Object previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class COWSubList
    extends AbstractList {
        private final CopyOnWriteArrayList l;
        private final int offset;
        private int size;
        private Object[] expectedArray;

        private COWSubList(CopyOnWriteArrayList copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.array;
            this.offset = n;
            this.size = n2 - n;
        }

        private void checkForComodification() {
            if (this.l.array != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int n, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                Object object2 = this.l.set(n + this.offset, object);
                this.expectedArray = this.l.array;
                return object2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                return this.l.get(n + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int n, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n + this.offset, object);
                this.expectedArray = this.l.array;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                this.l.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.array;
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                Object object = this.l.remove(n + this.offset);
                this.expectedArray = this.l.array;
                --this.size;
                return object;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(this.l, 0, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
                }
                return new COWSubListIterator(this.l, n, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int n, int n2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.l, n + this.offset, n2 + this.offset);
            }
        }
    }

    private static final class COWIterator
    implements ListIterator {
        private final Object[] array;
        private int cursor;

        private COWIterator(Object[] objectArray, int n) {
            this.array = objectArray;
            this.cursor = n;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

