/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MatchMap
extends AbstractMap {
    private static final char FREE_STATE = '\u0000';
    private static final char INITIAL_STATE = '\u0001';
    private Entry[] data = new Entry[64];
    private char[] base = new char[64];
    private char[] firstInput = new char[64];
    private char[] check = new char[64];
    private char[] next = new char[64];
    private char[] nextInput = new char[64];
    private char freeList = '\u0000';
    private int size;
    private final boolean ignoreCase;

    public MatchMap() {
        this(false);
    }

    public MatchMap(boolean bl) {
        this.ignoreCase = bl;
        for (int i = this.base.length - 2; i > 1; --i) {
            this.base[i] = (char)(i + 1);
        }
        this.freeList = (char)2;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Object clone() {
        MatchMap matchMap = new MatchMap(this.ignoreCase);
        matchMap.data = new Entry[this.data.length];
        System.arraycopy(this.data, 0, matchMap.data, 0, this.data.length);
        matchMap.base = MatchMap.clone(this.base);
        matchMap.firstInput = MatchMap.clone(this.firstInput);
        matchMap.check = MatchMap.clone(this.check);
        matchMap.next = MatchMap.clone(this.next);
        matchMap.nextInput = MatchMap.clone(this.nextInput);
        matchMap.freeList = this.freeList;
        matchMap.size = this.size;
        return matchMap;
    }

    private static char[] clone(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    public Map.Entry match(String string) {
        char c = '\u0001';
        Entry entry = this.data[c];
        int n = 0;
        int n2 = this.check.length;
        if (this.ignoreCase) {
            int n3;
            for (int i = string.length(); i > 0 && (n3 = this.base[c] + Character.toUpperCase(string.charAt(n))) < n2 && this.check[n3] == c; --i) {
                c = this.next[n3];
                Entry entry2 = this.data[c];
                if (entry2 != null) {
                    entry = entry2;
                }
                ++n;
            }
        } else {
            int n4;
            for (int i = string.length(); i > 0 && (n4 = this.base[c] + string.charAt(n)) < n2 && this.check[n4] == c; --i) {
                c = this.next[n4];
                Entry entry3 = this.data[c];
                if (entry3 != null) {
                    entry = entry3;
                }
                ++n;
            }
        }
        return entry;
    }

    public Object get(char[] cArray, int n, int n2) {
        char c = '\u0001';
        int n3 = this.check.length;
        while (n2 > 0) {
            int n4 = this.base[c] + cArray[n];
            if (n4 >= n3 || this.check[n4] != c) {
                return null;
            }
            c = this.next[n4];
            ++n;
            --n2;
        }
        Entry entry = this.data[c];
        return entry == null ? null : entry.value;
    }

    public Object get(String string) {
        return this.get(string.toCharArray(), 0, string.length());
    }

    public Entry put(CharSequence charSequence, Object object) {
        char c = '\u0001';
        for (int i = 0; i < charSequence.length(); ++i) {
            int n;
            char c2;
            char c3 = charSequence.charAt(i);
            if (this.ignoreCase) {
                c3 = Character.toUpperCase(c3);
            }
            if ((c2 = this.safeCheck(n = this.base[c] + c3)) == c) {
                c = this.next[n];
                continue;
            }
            if (c2 != '\u0000') {
                this.base[c] = this.rebase(c, c3);
                n = this.base[c] + c3;
            }
            this.check[n] = c;
            this.nextInput[n] = this.firstInput[c];
            this.firstInput[c] = c3;
            this.next[n] = c = this.newState();
        }
        Entry entry = this.data[c];
        this.data[c] = new Entry(charSequence, object);
        if (entry == null) {
            ++this.size;
        }
        return entry;
    }

    public Object remove(CharSequence charSequence) {
        char c;
        int n;
        int n2 = charSequence.length();
        char[] cArray = new char[n2];
        char c2 = '\u0001';
        for (int i = 0; i < n2; ++i) {
            cArray[i] = c2;
            n = charSequence.charAt(i);
            if (this.ignoreCase) {
                n = Character.toUpperCase((char)n);
            }
            if ((c = this.base[c2] + n) >= this.check.length || this.check[c] != c2) {
                return null;
            }
            c2 = this.next[c];
        }
        Entry entry = this.data[c2];
        if (entry != null) {
            --this.size;
            this.data[c2] = null;
        }
        for (n = n2 - 1; n >= 0 && this.isLeaf(c2) && this.data[c2] == null; --n) {
            c = cArray[n];
            this.freeState(c, charSequence.charAt(n), c2);
            c2 = c;
        }
        return entry == null ? null : entry.value;
    }

    public Set entrySet() {
        return new AbstractSet(){

            public int size() {
                return MatchMap.this.size;
            }

            public Iterator iterator() {
                return new EntryIterator();
            }
        };
    }

    private char safeCheck(int n) {
        if (n >= this.check.length) {
            this.check = MatchMap.grow(this.check, 2 * n);
            this.next = MatchMap.grow(this.next, 2 * n);
            this.nextInput = MatchMap.grow(this.nextInput, 2 * n);
        }
        return this.check[n];
    }

    private static char[] grow(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    private static Entry[] grow(Entry[] entryArray, int n) {
        Entry[] entryArray2 = new Entry[n];
        System.arraycopy(entryArray, 0, entryArray2, 0, entryArray.length);
        return entryArray2;
    }

    private char rebase(char c, char c2) {
        char c3 = this.base[c];
        char c4 = this.firstInput[c];
        char c5 = '\u0000';
        while (!this.isFree(c5, c3, c4, c2)) {
            c5 = (char)(c5 + 1);
        }
        this.base[c] = c5;
        char c6 = c4;
        while (c6 != '\u0000') {
            this.check[c5 + c6] = c;
            this.next[c5 + c6] = this.next[c3 + c6];
            this.nextInput[c5 + c6] = this.nextInput[c3 + c6];
            this.check[c3 + c6] = '\u0000';
            c6 = this.nextInput[c3 + c6];
        }
        return c5;
    }

    private char[] getInputs(int n, char c, int n2) {
        if (c == '\u0000') {
            return new char[n2];
        }
        char[] cArray = this.getInputs(n, this.nextInput[n + c], n2 + 1);
        cArray[n2] = c;
        return cArray;
    }

    private boolean isFree(int n, int n2, char c, char c2) {
        if (this.safeCheck(n + c2) != '\u0000') {
            return false;
        }
        char c3 = c;
        while (c3 != '\u0000') {
            if (this.safeCheck(n + c3) != '\u0000') {
                return false;
            }
            c3 = this.nextInput[n2 + c3];
        }
        return true;
    }

    private char newState() {
        if (this.freeList == '\u0000') {
            int n = this.base.length;
            int n2 = 2 * n;
            this.base = MatchMap.grow(this.base, n2);
            this.data = MatchMap.grow(this.data, n2);
            this.firstInput = MatchMap.grow(this.firstInput, n2);
            for (int i = n2 - 2; i > n; --i) {
                this.base[i] = (char)(i + 1);
            }
            this.freeList = (char)(n + 1);
            return (char)n;
        }
        char c = this.freeList;
        this.freeList = this.base[this.freeList];
        this.base[c] = '\u0000';
        this.firstInput[c] = '\u0000';
        return c;
    }

    void freeState(char c, char c2, char c3) {
        this.base[c3] = this.freeList;
        this.freeList = c3;
        char c4 = this.base[c];
        this.check[c4 + c2] = '\u0000';
        char c5 = this.firstInput[c];
        if (c5 == c2) {
            this.firstInput[c] = this.nextInput[c4 + c5];
            return;
        }
        while (true) {
            char c6;
            if ((c6 = this.nextInput[c4 + c5]) == c2) {
                this.nextInput[c4 + c5] = this.nextInput[c4 + c6];
                return;
            }
            c5 = c6;
        }
    }

    private boolean isLeaf(char c) {
        return this.firstInput[c] == '\u0000';
    }

    public static class Test {
        public static void main(String[] stringArray) throws Exception {
            String string;
            String string2 = stringArray.length > 0 ? stringArray[0] : "c:/emacs-20.3.1/ispell4/ispell.words";
            MatchMap matchMap = new MatchMap();
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string2));
            for (int i = 0; i < 2000; ++i) {
                String string3 = dataInputStream.readLine();
                matchMap.put(string3, string3);
            }
            dataInputStream.close();
            dataInputStream = new DataInputStream(new FileInputStream(string2));
            long l = System.currentTimeMillis();
            int n = 0;
            while ((string = dataInputStream.readLine()) != null) {
                for (int i = 10000; i > 0; --i) {
                    matchMap.match(string);
                    ++n;
                }
            }
            long l2 = System.currentTimeMillis() - l;
            System.out.println(n + " in " + l2 + "ms = " + ((long)n + l2 / 2L) / l2 + "K/s");
        }
    }

    static final class Entry
    implements Map.Entry {
        private final CharSequence key;
        private final Object value;

        Entry(CharSequence charSequence, Object object) {
            this.key = charSequence;
            this.value = object;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    class EntryIterator
    implements Iterator {
        private int index;

        EntryIterator() {
            int n;
            for (n = MatchMap.this.data.length - 1; n >= 0 && MatchMap.this.data[n] == null; --n) {
            }
            this.index = n;
        }

        public boolean hasNext() {
            return this.index >= 0;
        }

        public Object next() {
            Entry entry = MatchMap.this.data[this.index--];
            while (this.index >= 0 && MatchMap.this.data[this.index] == null) {
                --this.index;
            }
            return entry;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

