/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.Map;
import java.util.StringTokenizer;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;
import weblogic.utils.UnsyncStringBuffer;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.http.BytesToString;
import weblogic.utils.http.QueryParams;

public final class HttpParsing {
    static BitSet dontNeedEncoding;
    private static final String platformEncoding;

    private HttpParsing() {
    }

    public static String[] getAuthInfo(String string) {
        int n;
        byte[] byArray;
        if (string == null) {
            return null;
        }
        String[] stringArray = StringUtils.split(string, ' ');
        if (stringArray.length < 2 || !"Basic".equals(stringArray[0]) || stringArray[1] == null) {
            return null;
        }
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byArray = bASE64Decoder.decodeBuffer(stringArray[1]);
        }
        catch (IOException iOException) {
            return null;
        }
        for (n = 0; n < byArray.length && byArray[n] != 58; ++n) {
        }
        if (n >= byArray.length - 1) {
            return null;
        }
        String[] stringArray2 = new String[]{new String(byArray, 0, 0, n), new String(byArray, 0, ++n, byArray.length - n)};
        return stringArray2;
    }

    public static void parseQueryString(String string, Map map) {
        HttpParsing.parseQueryString(string, map, null);
    }

    public static void parseQueryString(String string, Map map, String string2) {
        int n = string.indexOf(35);
        if (n > 0) {
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace('+', ' '), "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String[] stringArray = StringUtils.split(string3, '=');
            map.put(HttpParsing.unescape(stringArray[0], string2), HttpParsing.unescape(stringArray[1], string2));
        }
    }

    public static void parseQueryString(byte[] byArray, Map map, String string) {
        int n = byArray.length;
        int n2 = 0;
        while (true) {
            String string2;
            String string3;
            int n3;
            boolean bl = true;
            int n4 = -1;
            for (n3 = n2; n3 < n; ++n3) {
                if (byArray[n3] == 61 && bl) {
                    n4 = n3;
                    bl = false;
                }
                if (byArray[n3] == 38) break;
            }
            if (n4 >= 0) {
                if (BytesToString.is8BitUnicodeSubset(string)) {
                    string3 = new String(HttpParsing.unescape(byArray, n2, n4 - n2), 0);
                    string2 = new String(HttpParsing.unescape(byArray, ++n4, n3 - n4), 0);
                } else {
                    try {
                        string3 = new String(HttpParsing.unescape(byArray, n2, n4 - n2), string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string3 = new String(HttpParsing.unescape(byArray, n2, n4 - n2));
                    }
                    ++n4;
                    try {
                        string2 = new String(HttpParsing.unescape(byArray, n4, n3 - n4), string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string2 = new String(HttpParsing.unescape(byArray, n4, n3 - n4));
                    }
                }
                map.put(string3, string2);
            } else if (n3 > n2) {
                if (string == null) {
                    string3 = new String(HttpParsing.unescape(byArray, n2, n3 - n2));
                } else {
                    try {
                        string3 = new String(HttpParsing.unescape(byArray, n2, n3 - n2), string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string3 = new String(HttpParsing.unescape(byArray, n2, n3 - n2));
                    }
                }
                string2 = "";
                map.put(string3, string2);
            }
            if (++n3 >= n) break;
            n2 = n3;
        }
    }

    public static void prependQueryString(String string, QueryParams queryParams, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace('+', ' '), "&");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        String[] stringArray = new String[n];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        int n3 = stringArray.length;
        while (--n3 >= 0) {
            String[] stringArray2 = StringUtils.split(stringArray[n3], '=');
            queryParams.prepend(HttpParsing.unescape(stringArray2[0], string2), HttpParsing.unescape(stringArray2[1], string2));
            stringArray[n3] = null;
        }
    }

    public static String makeURI(String string, String[][] stringArray) {
        return HttpParsing.makeURI(string, stringArray, null);
    }

    public static String makeURI(String string, String[][] stringArray, String string2) {
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer(string);
        int n = stringArray.length;
        if (string.indexOf(63) < 0) {
            unsyncStringBuffer.append('?');
        } else if (n > 0) {
            unsyncStringBuffer.append('&');
        }
        for (int i = 0; i < n; ++i) {
            unsyncStringBuffer.append(HttpParsing.isURLEncoded(stringArray[i][0]) ? stringArray[i][0] : HttpParsing.escape(stringArray[i][0], string2));
            unsyncStringBuffer.append('=');
            unsyncStringBuffer.append(HttpParsing.isURLEncoded(stringArray[i][1]) ? stringArray[i][1] : HttpParsing.escape(stringArray[i][1], string2));
            if (i >= n - 1) continue;
            unsyncStringBuffer.append('&');
        }
        return unsyncStringBuffer.toString();
    }

    private static boolean isURLEncoded(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                return false;
            }
            if (dontNeedEncoding.get(c)) continue;
            if (c == '%' && i + 2 < n && Hex.isHexChar(string.charAt(i + 1)) && Hex.isHexChar(string.charAt(i + 2))) {
                i += 2;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String escape(String string, String string2) {
        if (string2 != null) {
            String string3 = null;
            try {
                string3 = URLEncoder.encode(string, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = URLEncoder.encode(string);
            }
            return string3;
        }
        return HttpParsing.escape(string);
    }

    public static String escape(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        string.getBytes(0, n, byArray, 0);
        StringBuffer stringBuffer = new StringBuffer(byArray.length + 16);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (HttpParsing.isUnsafe(by) || by == 32) {
                stringBuffer.append("%" + Hex.asHex(by));
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        return HttpParsing.unescape(string, null);
    }

    public static String unescape(String string, String string2) {
        if (string.indexOf(37) < 0) {
            return string;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = platformEncoding;
        }
        int n = 0;
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] == 37 && n3 + 2 < n2 && Hex.isHexChar(byArray[n3 + 1]) && Hex.isHexChar(byArray[n3 + 2])) {
                byArray[n] = (byte)((Hex.hexValueOf(byArray[n3 + 1]) << 4) + (Hex.hexValueOf(byArray[n3 + 2]) << 0));
                n3 += 2;
            } else {
                if (!(bl || byArray[n3] > 31 && byArray[n3] != 127)) {
                    string2 = System.getProperty("file.encoding");
                    bl = true;
                }
                byArray[n] = byArray[n3];
            }
            ++n3;
            ++n;
        }
        return BytesToString.newString(byArray, 0, n, string2);
    }

    public static byte[] unescape(byte[] byArray, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            if (byArray[i] == 37 && i + 2 < n4 && Hex.isHexChar(byArray[i + 1]) && Hex.isHexChar(byArray[i + 2])) {
                ++n3;
                i += 2;
                continue;
            }
            if (byArray[i] != 43) continue;
            bl = true;
        }
        if (n3 == 0 && !bl) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        byte[] byArray3 = new byte[n2 - n3 * 2];
        int n5 = 0;
        for (int i = n; i < n4; ++i) {
            if (byArray[i] == 37 && i + 2 < n4 && Hex.isHexChar(byArray[i + 1]) && Hex.isHexChar(byArray[i + 2])) {
                byArray3[n5++] = (byte)((Hex.hexValueOf(byArray[i + 1]) << 4) + (Hex.hexValueOf(byArray[i + 2]) << 0));
                i += 2;
                continue;
            }
            byArray3[n5++] = byArray[i] == 43 ? 32 : byArray[i];
        }
        return byArray3;
    }

    public static byte[] unescape(byte[] byArray) {
        return HttpParsing.unescape(byArray, 0, byArray.length);
    }

    public static final boolean isUnsafe(int n) {
        if (n >= 0 && n <= 31 || n >= 127 && n <= 255) {
            return true;
        }
        switch (n) {
            case 34: 
            case 35: 
            case 37: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 92: 
            case 94: 
            case 96: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static final String StripHTTPFieldValue(String string) {
        int n = string.indexOf(40);
        if (n > 0) {
            string = string.substring(0, n).trim();
        }
        if (string.length() > 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1).trim();
        }
        return string;
    }

    public static final String ensureStartingSlash(String string) {
        int n = string.length();
        if (n == 0) {
            return "/";
        }
        if (string.charAt(0) == '/') {
            return string;
        }
        return new StringBuffer(n + 1).append('/').append(string).toString();
    }

    public static final String ensureEndingSlash(String string) {
        int n = string.length();
        if (n == 0) {
            return "/";
        }
        if (string.charAt(n - 1) == '/') {
            return string;
        }
        return new StringBuffer(n + 1).append(string).append('/').toString();
    }

    static {
        int n;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(91);
        dontNeedEncoding.set(93);
        platformEncoding = null;
        try {
            System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

