/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import weblogic.utils.io.ByteBufferDataInputStream;

public class ByteBufferObjectInputStream
extends ByteBufferDataInputStream
implements ObjectInput {
    private ObjectInputStream ois;

    public ByteBufferObjectInputStream(ByteBuffer[] byteBufferArray) throws IOException {
        super(byteBufferArray);
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        if (this.ois == null) {
            this.ois = new ContextObjectInputStream(this);
        }
        return this.ois.readObject();
    }

    private static class ContextObjectInputStream
    extends ObjectInputStream {
        public ContextObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            this.enableResolveObject(true);
        }

        public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return Class.forName(objectStreamClass.getName(), true, Thread.currentThread().getContextClassLoader());
        }
    }
}

