/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import weblogic.utils.StringUtils;

public final class DataIO {
    private DataIO() {
    }

    public static void writeBoolean(OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(bl ? 1 : 0);
    }

    public static void writeByte(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n);
    }

    public static void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 0 & 0xFF);
    }

    public static void writeChar(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 0 & 0xFF);
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 24 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 0 & 0xFF);
    }

    public static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l >>> 56) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)(l >>> 0) & 0xFF);
    }

    public static void writeFloat(OutputStream outputStream, float f) throws IOException {
        DataIO.writeInt(outputStream, Float.floatToIntBits(f));
    }

    public static void writeDouble(OutputStream outputStream, double d) throws IOException {
        DataIO.writeLong(outputStream, Double.doubleToLongBits(d));
    }

    public static void writeBytes(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            outputStream.write((byte)string.charAt(i));
        }
    }

    public static void writeChars(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            outputStream.write(c >>> 8 & 0xFF);
            outputStream.write(c >>> 0 & 0xFF);
        }
    }

    public static void writeUTF(OutputStream outputStream, String string) throws IOException {
        int n = StringUtils.getUTFLength(string);
        if (n > 65535) {
            throw new UTFDataFormatException();
        }
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 0 & 0xFF);
        if (n == string.length()) {
            DataIO.writeBytes(outputStream, string);
        } else {
            for (int i = 0; i < string.length(); ++i) {
                DataIO.writeUTF(outputStream, string.charAt(i));
            }
        }
    }

    public static int writeUTF(OutputStream outputStream, int n) throws IOException {
        if (n >= 1 && n <= 127) {
            outputStream.write((byte)n);
            return 1;
        }
        if (n > 2047) {
            outputStream.write((byte)(0xE0 | n >> 12 & 0xF));
            outputStream.write((byte)(0x80 | n >> 6 & 0x3F));
            outputStream.write((byte)(0x80 | n >> 0 & 0x3F));
            return 3;
        }
        outputStream.write((byte)(0xC0 | n >> 6 & 0x1F));
        outputStream.write((byte)(0x80 | n >> 0 & 0x3F));
        return 2;
    }

    public static int writeUTFChar(DataOutput dataOutput, int n) throws IOException {
        if (n >= 1 && n <= 127) {
            dataOutput.write((byte)n);
            return 1;
        }
        if (n > 2047) {
            dataOutput.write((byte)(0xE0 | n >> 12 & 0xF));
            dataOutput.write((byte)(0x80 | n >> 6 & 0x3F));
            dataOutput.write((byte)(0x80 | n >> 0 & 0x3F));
            return 3;
        }
        dataOutput.write((byte)(0xC0 | n >> 6 & 0x1F));
        dataOutput.write((byte)(0x80 | n >> 0 & 0x3F));
        return 2;
    }

    public static void writeUTF8(OutputStream outputStream, String string) throws IOException {
        char c;
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if ((c & 0xFF80) == 0) {
                ++n2;
                continue;
            }
            if ((c & 0xF800) == 0) {
                n2 += 2;
                continue;
            }
            n2 += 3;
        }
        DataIO.writeInt(outputStream, n2);
        if (n2 == string.length()) {
            DataIO.writeBytes(outputStream, string);
        } else {
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if ((c & 0xFF80) == 0) {
                    outputStream.write((byte)c);
                    continue;
                }
                if ((c & 0xF800) == 0) {
                    outputStream.write((byte)(0xC0 | c >> 6 & 0x1F));
                    outputStream.write((byte)(0x80 | c >> 0 & 0x3F));
                    continue;
                }
                outputStream.write((byte)(0xE0 | c >> 12 & 0xF));
                outputStream.write((byte)(0x80 | c >> 6 & 0x3F));
                outputStream.write((byte)(0x80 | c >> 0 & 0x3F));
            }
        }
    }

    public static void writeASCII(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        DataIO.writeLength(outputStream, n);
        for (int i = 0; i < n; ++i) {
            outputStream.write((byte)string.charAt(i));
        }
    }

    public static void writeLength(OutputStream outputStream, int n) throws IOException {
        if (n >= 0) {
            if (n < 254) {
                outputStream.write(n);
                return;
            }
            if (n <= 65535) {
                outputStream.write(254);
                outputStream.write(n >> 8);
                outputStream.write(n & 0xFF);
                return;
            }
        }
        outputStream.write(255);
        DataIO.writeInt(outputStream, n);
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        DataIO.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public static int skipBytes(InputStream inputStream, int n) throws IOException {
        for (int i = 0; i < n; i += (int)inputStream.skip(n - i)) {
        }
        return n;
    }

    public static boolean readBoolean(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public static byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public static int readUnsignedByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public static short readShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public static int readUnsignedShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public static char readChar(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public static int readInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public static long readLong(InputStream inputStream) throws IOException {
        return ((long)DataIO.readInt(inputStream) << 32) + ((long)DataIO.readInt(inputStream) & 0xFFFFFFFFL);
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(DataIO.readInt(inputStream));
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(DataIO.readLong(inputStream));
    }

    public static final String readLine(InputStream inputStream) throws IOException {
        char[] cArray = new char[128];
        int n = 0;
        int n2 = inputStream.read();
        while (true) {
            if (n2 == -1) {
                if (n != 0) break;
                return null;
            }
            if (n2 == 10) {
                if (n <= 0 || cArray[n - 1] != '\r') break;
                --n;
                break;
            }
            if (n == cArray.length) {
                char[] cArray2 = cArray;
                cArray = new char[n + 128];
                System.arraycopy(cArray2, 0, cArray, 0, n);
            }
            cArray[n++] = (char)n2;
            n2 = inputStream.read();
        }
        return String.copyValueOf(cArray, 0, n);
    }

    public static String readUTF(InputStream inputStream) throws IOException {
        int n = DataIO.readUnsignedShort(inputStream);
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        block5: while (n2 < n) {
            int n4 = DataIO.readUnsignedByte(inputStream);
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = DataIO.readUnsignedByte(inputStream);
                    if ((n5 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = DataIO.readUnsignedByte(inputStream);
                    int n6 = DataIO.readUnsignedByte(inputStream);
                    if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | (n6 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n3);
    }

    public static final String readUTF8(InputStream inputStream) throws IOException {
        int n = DataIO.readInt(inputStream);
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5 = DataIO.readUnsignedByte(inputStream) & 0xFF;
            if ((n5 & 0x80) == 0) {
                ++n2;
            } else if ((n5 & 0xE0) == 192) {
                n4 = DataIO.readUnsignedByte(inputStream) & 0xFF;
                n5 = ((n5 & 0x1F) << 6) + (n4 & 0x3F);
                n2 += 2;
            } else {
                n4 = DataIO.readUnsignedByte(inputStream) & 0xFF;
                int n6 = DataIO.readUnsignedByte(inputStream) & 0xFF;
                n5 = ((n5 & 0xF) << 12) + ((n4 & 0x3F) << 6) + (n6 & 0x3F);
                n2 += 3;
            }
            cArray[n3++] = (char)n5;
        }
        return StringUtils.getString(cArray, 0, n3);
    }

    public static final String readUTF8(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3;
            if (((n3 = byArray[n++] & 0xFF) & 0x80) != 0) {
                int n4;
                if ((n3 & 0xE0) == 192) {
                    n4 = byArray[n++] & 0xFF;
                    n3 = ((n3 & 0x1F) << 6) + (n4 & 0x3F);
                } else {
                    n4 = byArray[n++] & 0xFF;
                    int n5 = byArray[n++] & 0xFF;
                    n3 = ((n3 & 0xF) << 12) + ((n4 & 0x3F) << 6) + (n5 & 0x3F);
                }
            }
            cArray[n2++] = (char)n3;
        }
        return StringUtils.getString(cArray, 0, n2);
    }

    public static String readASCII(InputStream inputStream) throws IOException {
        int n = DataIO.readLength(inputStream);
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)DataIO.readUnsignedByte(inputStream);
        }
        return new String(cArray);
    }

    public static int readLength(InputStream inputStream) throws IOException {
        int n = DataIO.readUnsignedByte(inputStream);
        if (n < 254) {
            return n;
        }
        if (n == 255) {
            return DataIO.readInt(inputStream);
        }
        n = DataIO.readUnsignedByte(inputStream) << 8;
        return n + DataIO.readUnsignedByte(inputStream);
    }
}

